<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class ItemAttributeSet extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemAttributeSet';
    }    
    
    public function getItemAttributeSet(int $itemAttributeSetId): object {
        return $this->getSingle($itemAttributeSetId);
    }
    
    public function getInventories(): object {
        return $this->getAll();
    }
    
    public function createItemAttributeSet(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateItemAttributeSet(int $itemAttributeSetId, array|object $data): object {
        return $this->update($itemAttributeSetId, $data);
    }
    
    public function deleteItemAttributeSet(int $itemAttributeSetId): object {
        return $this->delete($itemAttributeSetId);
    }
    
    public function getItemAttributeSetBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getItemAttributeSetAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getItemAttributeSetBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}