<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Item extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Item';
    }    
    
    public function getItem(int $itemId): object {
        return $this->getSingle($itemId);
    }
    
    public function getItems(): object {
        return $this->getAll();
    }
    
    public function createItem(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateItem(int $itemId, array|object $data): object {
        return $this->update($itemId, $data);
    }
    
    public function deleteItem(int $itemId): object {
        return $this->delete($itemId);
    }
    
    public function getItemBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getItemAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getItemBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchItem(array $query): ?object {
        return $this->search($query);
    }
}