<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class InventoryCountReconcile extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCountReconcile';
    }    
    
    public function getInventoryCountReconcile(int $inventoryCountId): object {
        return $this->getSingle($inventoryCountId);
    }
    
    public function getInventoryCountReconciles(): object {
        return $this->getAll();
    }
    
    public function createInventoryCountReconcile(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateInventoryCountReconcile(int $inventoryCountId, array|object $data): object {
        return $this->update($inventoryCountId, $data);
    }
    
    public function deleteInventoryCountReconcile(int $inventoryCountId): object {
        return $this->delete($inventoryCountId);
    }
    
    public function getInventoryCountReconcileBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryCountReconcileAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getInventoryCountReconcileBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchInventoryCountReconcile(array $query): ?object {
        return $this->search($query);
    }
}