<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class InventoryCountItem extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCountItem';
    }    
    
    public function getInventoryCountItem(int $inventoryCountId): object {
        return $this->getSingle($inventoryCountId);
    }
    
    public function searchInventoryCountItems(array $query): ?object {
        return $this->search($query);
    }
    

}