<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class InventoryCount extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCount';
    }    
    
    public function getInventoryCount(int $inventoryCountId): object {
        return $this->getSingle($inventoryCountId);
    }
    
    public function getInventoryCounts(): object {
        return $this->getAll();
    }
    
    public function createInventoryCount(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateInventoryCount(int $inventoryCountId, array|object $data): object {
        return $this->update($inventoryCountId, $data);
    }
    
    public function deleteInventoryCount(int $inventoryCountId): object {
        return $this->delete($inventoryCountId);
    }
    
    public function getInventoryCountBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryCountAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getInventoryCountBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchInventoryCount(array $query): ?object {
        return $this->search($query);
    }
}