<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Inventory extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Inventory';
    }    
    
    public function getInventory(int $inventoryId): object {
        return $this->getSingle($inventoryId);
    }
    
    public function getInventories(): object {
        return $this->getAll();
    }
    
    public function createInventory(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateInventory(int $inventoryId, array|object $data): object {
        return $this->update($inventoryId, $data);
    }
    
    public function deleteInventory(int $inventoryId): object {
        return $this->delete($inventoryId);
    }
    
    public function getInventoryBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getInventoryBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}