<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Employee extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Employee';
    }    
    
    public function getEmployee(int $employeeId): object {
        return $this->getSingle($employeeId);
    }
    
    public function getInventories(): object {
        return $this->getAll();
    }
    
    public function createEmployee(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateEmployee(int $employeeId, array|object $data): object {
        return $this->update($employeeId, $data);
    }
    
    public function deleteEmployee(int $employeeId): object {
        return $this->delete($employeeId);
    }
    
    public function getEmployeeBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getEmployeeAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getEmployeeBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}