<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class CustomerType extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'CustomerType';
    }    
    
    public function getCustomerType(int $customerTypeId): object {
        return $this->getSingle($customerTypeId);
    }
    
    public function getCustomerTypes(): object {
        return $this->getAll();
    }
    
    public function createCustomerType(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateCustomerType(int $customerTypeId, array|object $data): object {
        return $this->update($customerTypeId, $data);
    }
    
    public function deleteCustomerType(int $customerTypeId): object {
        return $this->delete($customerTypeId);
    }
    
    public function getCustomerTypeBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCustomerTypeAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getCustomerTypeBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchCustomerType(array $query): ?object {
        return $this->search($query);
    }
}