<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Customer extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Customer';
    }    
    
    public function getCustomer(int $customerId): object {
        return $this->getSingle($customerId);
    }
    
    public function getCustomers(): object {
        return $this->getAll();
    }
    
    public function createCustomer(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateCustomer(int $customerId, array|object $data): object {
        return $this->update($customerId, $data);
    }
    
    public function deleteCustomer(int $customerId): object {
        return $this->delete($customerId);
    }
    
    public function getCustomerBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCustomerAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getCustomerBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchCustomer(array $query): ?object {
        return $this->search($query);
    }
    
}