<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class CustomField extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Customer/CustomField';
    }    
    
    public function getCustomField(int $customerId): object {
        return $this->getSingle($customerId, 'CustomFieldChoice');
    }
   
    
}