<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Category extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Category';
    }    
    
    public function getCategory(int $categoryId): object {
        return $this->getSingle($categoryId);
    }
    
    public function getCategories(): object {
        return $this->getAll();
    }
    
    public function createCategory(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateCategory(int $categoryId, array|object $data): object {
        return $this->update($categoryId, $data);
    }
    
    public function deleteCategory(int $categoryId): object {
        return $this->delete($categoryId);
    }
    
    public function getCategoryBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCategoryAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getCategoryBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchCategory(array $query): ?object {
        return $this->search($query);
    }
    
}