<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class AttributeSet extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemAttributeSet';
    }    
    
    public function getAttributeSet(int $attributeSetId): object {
        return $this->getSingle($attributeSetId);
    }
    
    public function getAttributeSets(): object {
        return $this->getAll();
    }
    
    public function createAttributeSet(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateAttributeSet(int $attributeSetId, array|object $data): object {
        return $this->update($attributeSetId, $data);
    }
    
    public function deleteAttributeSet(int $attributeSetId): object {
        return $this->delete($attributeSetId);
    }
    
    public function getAttributeSetBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getAttributeSetAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getAttributeSetBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchAttributeSet(array $query): ?object {
        return $this->search($query);
    }
    
}