<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class VendorReturn extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'VendorReturn';
    }    
    
    public function getVendorReturn($vendorId) {
        return $this->getSingle($vendorId);
    }
    
    public function getVendorReturns() {
        return $this->getAll();
    }
    
    public function createVendorReturn($data) {
         return $this->create($data);
    }
    
    public function updateVendorReturn($vendorId, $data) {
        return $this->update($vendorId, $data);
    }
    
    public function deleteVendorReturn($vendorId) {
        return $this->delete($vendorId);
    }
    
    public function getVendorReturnBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getVendorReturnAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getVendorReturnBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchVendorReturns(array $query) {
        return $this->search($query);
    }
}