<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Vendor extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Vendor';
    }    
    
    public function getVendor($vendorId) {
        return $this->getSingle($vendorId);
    }
    
    public function getVendors() {
        return $this->getAll();
    }
    
    public function createVendor($data) {
         return $this->create($data);
    }
    
    public function updateVendor($vendorId, $data) {
        return $this->update($vendorId, $data);
    }
    
    public function deleteVendor($vendorId) {
        return $this->delete($vendorId);
    }
    
    public function getVendorBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getVendorAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getVendorBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchVendors(array $query) {
        return $this->search($query);
    }
}