<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class TaxClass extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxClass';
    }    
    
    public function getTaxClass($itemId) {
        return $this->getSingle($itemId);
    }
    
    public function getTaxClasses() {
        return $this->getAll();
    }
    
    public function createTaxClass($data) {
         return $this->create($data);
    }
    
    public function updateTaxClass($itemId, $data) {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxClass($itemId) {
        return $this->delete($itemId);
    }
    
    public function getTaxClassBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxClassAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getTaxClassBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchTaxClass(array $query) {
        return $this->search($query);
    }
}