<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class TaxCategoryClass extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxCategoryClass';
    }    
    
    public function getTaxCategoryClass($itemId) {
        return $this->getSingle($itemId);
    }
    
    public function getTaxCategoryClasses() {
        return $this->getAll();
    }
    
    public function createTaxCategoryClass($data) {
         return $this->create($data);
    }
    
    public function updateTaxCategoryClass($itemId, $data) {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxCategoryClass($itemId) {
        return $this->delete($itemId);
    }
    
    public function getTaxCategoryClassBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxCategoryClassAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getTaxCategoryClassBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchTaxCategoryClass(array $query) {
        return $this->search($query);
    }
}