<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class TaxCategory extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxCategory';
    }    
    
    public function getTaxCategory($itemId) {
        return $this->getSingle($itemId);
    }
    
    public function getTaxCategorys() {
        return $this->getAll();
    }
    
    public function createTaxCategory($data) {
         return $this->create($data);
    }
    
    public function updateTaxCategory($itemId, $data) {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxCategory($itemId) {
        return $this->delete($itemId);
    }
    
    public function getTaxCategoryBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxCategoryAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getTaxCategoryBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchTaxCategory(array $query) {
        return $this->search($query);
    }
}