<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Shop extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Shop';
    }    
    
    public function getShop($shopId) {
        return $this->getSingle($shopId);
    }
    
    public function getShops() {
        return $this->getAll();
    }
   
    public function searchShops(array $query) {
        return $this->search($query);
    }
}