<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class SalePayment extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'SalePayment';
    }    
    
    public function getSalePayment($saleLineId) {
        return $this->getSingle($saleLineId);
    }
    
    public function getSalePayments() {
        return $this->getAll();
    }
    
    public function createSalePayment($data) {
         return $this->create($data);
    }
    
    public function updateSalePayment($saleLineId, $data) {
        return $this->update($saleLineId, $data);
    }
    
    public function deleteSalePayment($saleLineId) {
        return $this->delete($saleLineId);
    }
    
    public function getSalePaymentBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSalePaymentAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getSalePaymentBefore($date) {
        return $this->getBefore($date);
    }
}