<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class SaleLine extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'SaleLine';
    }    
    
    public function getSaleLine($saleLineId) {
        return $this->getSingle($saleLineId);
    }
    
    public function getSaleLines() {
        return $this->getAll();
    }
    
    public function createSaleLine($data) {
         return $this->create($data);
    }
    
    public function updateSaleLine($saleLineId, $data) {
        return $this->update($saleLineId, $data);
    }
    
    public function deleteSaleLine($saleLineId) {
        return $this->delete($saleLineId);
    }
    
    public function getSaleLineBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSaleLineAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getSaleLineBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchSaleLine(array $query) {
        return $this->search($query);
    }
}