<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Sale extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Sale';
    }    
    
    public function getSale($saleId) {
        return $this->getSingle($saleId);
    }
    
    public function getSales() {
        return $this->getAll();
    }
    
    public function createSale($data) {
         return $this->create($data);
    }
    
    public function updateSale($saleId, $data) {
        return $this->update($saleId, $data);
    }
    
    public function deleteSale($saleId) {
        return $this->delete($saleId);
    }
    
    public function getSaleBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSaleAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getSaleBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchSales(array $query) {
        return $this->search($query);
    }
    
    public function getSaleRefund($saleId) {
        return $this->getSingle($saleId, 'refund');
    }
}