<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class RegisterCountAmount extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'RegisterCountAmount';
    }    
    
    public function getRegisterCountAmount($registerId) {
        return $this->getSingle($registerId);
    }
    
    public function getRegisterCountAmounts() {
        return $this->getAll();
    }
    
    public function searchRegisterCountAmounts(array $query) {
        return $this->search($query);
    }
    
    public function createRegisterCountAmount($data) {
         return $this->create($data);
    }
    
    public function updateRegisterCountAmount($registerId, $data) {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegisterCountAmount($registerId) {
        return $this->delete($registerId);
    }
    
    public function getRegisterCountAmountBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterCountAmountAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getRegisterCountAmountBefore($date) {
        return $this->getBefore($date);
    }
}