<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class RegisterCount extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'RegisterCount';
    }    
    
    public function getRegisterCount($registerId) {
        return $this->getSingle($registerId);
    }
    
    public function getRegisterCounts() {
        return $this->getAll();
    }
    
    public function searchRegisterCounts(array $query) {
        return $this->search($query);
    }
    
    public function createRegisterCount($data) {
         return $this->create($data);
    }
    
    public function updateRegisterCount($registerId, $data) {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegisterCount($registerId) {
        return $this->delete($registerId);
    }
    
    public function getRegisterCountBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterCountAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getRegisterCountBefore($date) {
        return $this->getBefore($date);
    }
}