<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Register extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Register';
    }    
    
    public function getRegister($registerId) {
        return $this->getSingle($registerId);
    }
    
    public function getRegisters() {
        return $this->getAll();
    }
    
    public function createRegister($data) {
         return $this->create($data);
    }
    
    public function updateRegister($registerId, $data) {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegister($registerId) {
        return $this->delete($registerId);
    }
    
    public function getRegisterBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getRegisterBefore($date) {
        return $this->getBefore($date);
    }
    
    public function getRegistersCalculated($registerId) {
        return $this->getSingle($registerId, 'calculated');
    }
    
    public function searchRegisters(array $query) {
        return $this->search($query);
    }
}