<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class PaymentType extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'PaymentType';
    }    
    
    public function getPaymentType($typeId) {
        return $this->getSingle($typeId);
    }
    
    public function getPaymentTypes() {
        return $this->getAll();
    }
    
    public function createPaymentType($data) {
         return $this->create($data);
    }
    
    public function updatePaymentType($typeId, $data) {
        return $this->update($typeId, $data);
    }
    
    public function deletePaymentType($typeId) {
        return $this->delete($typeId);
    }
    
    public function getPaymentTypeBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getPaymentTypeAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getPaymentTypeBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchPaymentType(array $query) {
        return $this->search($query);
    }
}