<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class OrderLine extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'OrderLine';
    }    
    
    public function getOrderLine($orderlineId) {
        return $this->getSingle($orderlineId);
    }
    
    public function getOrderLines() {
        return $this->getAll();
    }
    
    public function createOrderLine($data) {
         return $this->create($data);
    }
    
    public function updateOrderLine($orderlineId, $data) {
        return $this->update($orderlineId, $data);
    }
    
    public function deleteOrderLine($orderlineId) {
        return $this->delete($orderlineId);
    }
    
    public function getOrderLineBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getOrderLineAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getOrderLineBefore($date) {
        return $this->getBefore($date);
    }
}