<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Order extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Order';
    }    
    
    public function getOrder($orderId) {
        return $this->getSingle($orderId);
    }
    
    public function getOrders() {
        return $this->getAll();
    }
    
    public function createOrder($data) {
         return $this->create($data);
    }
    
    public function updateOrder($orderId, $data) {
        return $this->update($orderId, $data);
    }
    
    public function deleteOrder($orderId) {
        return $this->delete($orderId);
    }
    
    public function getOrderBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getOrderAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getOrderBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchOrders(array $query) {
        return $this->search($query);
    }
}