<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Matrix extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemMatrix';
    }    
    
    public function getMatrix($matrixId) {
        return $this->getSingle($matrixId);
    }
    
    public function getMatrixes() {
        return $this->getAll();
    }
    
        public function createMatrix($data) {
         return $this->create($data);
    }
    
    public function updateMatrix($matrixId, $data) {
        return $this->update($matrixId, $data);
    }
    
    public function deleteMatrix($matrixId) {
        return $this->delete($matrixId);
    }
    
    public function getMatrixBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getMatrixAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getMatrixBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchMatrix(array $query) {
        return $this->search($query);
    }
    
}