<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class ItemAttributeSet extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemAttributeSet';
    }    
    
    public function getItemAttributeSet($itemAttributeSetId) {
        return $this->getSingle($itemAttributeSetId);
    }
    
    public function getInventories() {
        return $this->getAll();
    }
    
    public function createItemAttributeSet($data) {
         return $this->create($data);
    }
    
    public function updateItemAttributeSet($itemAttributeSetId, $data) {
        return $this->update($itemAttributeSetId, $data);
    }
    
    public function deleteItemAttributeSet($itemAttributeSetId) {
        return $this->delete($itemAttributeSetId);
    }
    
    public function getItemAttributeSetBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getItemAttributeSetAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getItemAttributeSetBefore($date) {
        return $this->getBefore($date);
    }
}