<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Item extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Item';
    }    
    
    public function getItem($itemId) {
        return $this->getSingle($itemId);
    }
    
    public function getItems() {
        return $this->getAll();
    }
    
    public function createItem($data) {
         return $this->create($data);
    }
    
    public function updateItem($itemId, $data) {
        return $this->update($itemId, $data);
    }
    
    public function deleteItem($itemId) {
        return $this->delete($itemId);
    }
    
    public function getItemBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getItemAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getItemBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchItem(array $query) {
        return $this->search($query);
    }
}