<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class InventoryCountReconcile extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCountReconcile';
    }    
    
    public function getInventoryCountReconcile($inventoryCountId) {
        return $this->getSingle($inventoryCountId);
    }
    
    public function getInventoryCountReconciles() {
        return $this->getAll();
    }
    
    public function createInventoryCountReconcile($data) {
         return $this->create($data);
    }
    
    public function updateInventoryCountReconcile($inventoryCountId, $data) {
        return $this->update($inventoryCountId, $data);
    }
    
    public function deleteInventoryCountReconcile($inventoryCountId) {
        return $this->delete($inventoryCountId);
    }
    
    public function getInventoryCountReconcileBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryCountReconcileAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getInventoryCountReconcileBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchInventoryCountReconcile(array $query) {
        return $this->search($query);
    }
}