<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class InventoryCountItem extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCountItem';
    }    
    
    public function getInventoryCountItem($inventoryCountId) {
        return $this->getSingle($inventoryCountId);
    }
    
    public function searchInventoryCountItems(array $query) {
        return $this->search($query);
    }
    

}