<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class InventoryCount extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'InventoryCount';
    }    
    
    public function getInventoryCount($inventoryCountId) {
        return $this->getSingle($inventoryCountId);
    }
    
    public function getInventoryCounts() {
        return $this->getAll();
    }
    
    public function createInventoryCount($data) {
         return $this->create($data);
    }
    
    public function updateInventoryCount($inventoryCountId, $data) {
        return $this->update($inventoryCountId, $data);
    }
    
    public function deleteInventoryCount($inventoryCountId) {
        return $this->delete($inventoryCountId);
    }
    
    public function getInventoryCountBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryCountAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getInventoryCountBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchInventoryCount(array $query) {
        return $this->search($query);
    }
}