<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Inventory extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Inventory';
    }    
    
    public function getInventory($inventoryId) {
        return $this->getSingle($inventoryId);
    }
    
    public function getInventories() {
        return $this->getAll();
    }
    
    public function createInventory($data) {
         return $this->create($data);
    }
    
    public function updateInventory($inventoryId, $data) {
        return $this->update($inventoryId, $data);
    }
    
    public function deleteInventory($inventoryId) {
        return $this->delete($inventoryId);
    }
    
    public function getInventoryBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getInventoryAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getInventoryBefore($date) {
        return $this->getBefore($date);
    }
}