<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Employee extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Employee';
    }    
    
    public function getEmployee($employeeId) {
        return $this->getSingle($employeeId);
    }
    
    public function getInventories() {
        return $this->getAll();
    }
    
    public function createEmployee($data) {
         return $this->create($data);
    }
    
    public function updateEmployee($employeeId, $data) {
        return $this->update($employeeId, $data);
    }
    
    public function deleteEmployee($employeeId) {
        return $this->delete($employeeId);
    }
    
    public function getEmployeeBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getEmployeeAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getEmployeeBefore($date) {
        return $this->getBefore($date);
    }
}