<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class CustomerType extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'CustomerType';
    }    
    
    public function getCustomerType($customerTypeId) {
        return $this->getSingle($customerTypeId);
    }
    
    public function getCustomerTypes() {
        return $this->getAll();
    }
    
    public function createCustomerType($data) {
         return $this->create($data);
    }
    
    public function updateCustomerType($customerTypeId, $data) {
        return $this->update($customerTypeId, $data);
    }
    
    public function deleteCustomerType($customerTypeId) {
        return $this->delete($customerTypeId);
    }
    
    public function getCustomerTypeBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCustomerTypeAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getCustomerTypeBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchCustomerType(array $query) {
        return $this->search($query);
    }
}