<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Customer extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Customer';
    }    
    
    public function getCustomer($customerId) {
        return $this->getSingle($customerId);
    }
    
    public function getCustomers() {
        return $this->getAll();
    }
    
        public function createCustomer($data) {
         return $this->create($data);
    }
    
    public function updateCustomer($customerId, $data) {
        return $this->update($customerId, $data);
    }
    
    public function deleteCustomer($customerId) {
        return $this->delete($customerId);
    }
    
    public function getCustomerBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCustomerAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getCustomerBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchCustomer(array $query) {
        return $this->search($query);
    }
    
}