<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class Category extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Category';
    }    
    
    public function getCategory($categoryId) {
        return $this->getSingle($categoryId);
    }
    
    public function getCategories() {
        return $this->getAll();
    }
    
    public function createCategory($data) {
         return $this->create($data);
    }
    
    public function updateCategory($categoryId, $data) {
        return $this->update($categoryId, $data);
    }
    
    public function deleteCategory($categoryId) {
        return $this->delete($categoryId);
    }
    
    public function getCategoryBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getCategoryAfter($date) {
        return $this->getAfter($date);
    }
    
    public function getCategoryBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchCategory(array $query) {
        return $this->search($query);
    }
    
}