<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;  
use Lightspeed\CallAbstract;

class AttributeSet extends CallAbstract {

    public function __construct(LoggerInterface $logger, $token, $auth, $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemAttributeSet';
    }    
    
    public function getAttributeSet($attributeSetId) {
        return $this->getSingle($attributeSetId);
    }
    
    public function getAttributeSets() {
        return $this->getAll();
    }
    
        public function createAttributeSet($data) {
         return $this->create($data);
    }
    
    public function updateAttributeSet($attributeSetId, $data) {
        return $this->update($attributeSetId, $data);
    }
    
    public function deleteAttributeSet($attributeSetId) {
        return $this->delete($attributeSetId);
    }
    
    public function getAttributeSetBetweenDates($fromDate, $toDate) {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getAttributeSetAfter($date) {
        return$this->getAfter($date);
    }
    
    public function getAttributeSetBefore($date) {
        return $this->getBefore($date);
    }
    
    public function searchAttributeSet(array $query) {
        return $this->search($query);
    }
    
}