<?php
/**
 * Workorder
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Workorder Class Doc Comment
 *
 * @category Class
 * @description Workorder information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Workorder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Workorder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'workorder_id' => 'int',
        'time_in' => '\DateTime',
        'eta_out' => '\DateTime',
        'note' => 'string',
        'internal_note' => 'string',
        'warranty' => 'bool',
        'tax' => 'bool',
        'archived' => 'bool',
        'hook_in' => 'string',
        'hook_out' => 'string',
        'save_parts' => 'bool',
        'assign_employee_to_all' => 'bool',
        'customer_id' => 'int',
        'discount_id' => 'int',
        'employee_id' => 'int',
        'serialized_id' => 'int',
        'shop_id' => 'int',
        'sale_id' => 'int',
        'workorder_status_id' => 'int',
        'customer' => '\LightspeedV3\Model\Customer',
        'discount' => '\LightspeedV3\Model\Discount',
        'employee' => '\LightspeedV3\Model\Employee',
        'workorder_status' => '\LightspeedV3\Model\WorkorderStatus',
        'workorder_items' => '\LightspeedV3\Model\WorkorderWorkorderItems',
        'workorder_lines' => '\LightspeedV3\Model\WorkorderWorkorderLines'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'workorder_id' => null,
        'time_in' => 'date-time',
        'eta_out' => 'date-time',
        'note' => null,
        'internal_note' => null,
        'warranty' => null,
        'tax' => null,
        'archived' => null,
        'hook_in' => null,
        'hook_out' => null,
        'save_parts' => null,
        'assign_employee_to_all' => null,
        'customer_id' => null,
        'discount_id' => null,
        'employee_id' => null,
        'serialized_id' => null,
        'shop_id' => null,
        'sale_id' => null,
        'workorder_status_id' => null,
        'customer' => null,
        'discount' => null,
        'employee' => null,
        'workorder_status' => null,
        'workorder_items' => null,
        'workorder_lines' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'workorder_id' => false,
        'time_in' => false,
        'eta_out' => false,
        'note' => false,
        'internal_note' => false,
        'warranty' => false,
        'tax' => false,
        'archived' => false,
        'hook_in' => false,
        'hook_out' => false,
        'save_parts' => false,
        'assign_employee_to_all' => false,
        'customer_id' => false,
        'discount_id' => false,
        'employee_id' => false,
        'serialized_id' => false,
        'shop_id' => false,
        'sale_id' => false,
        'workorder_status_id' => false,
        'customer' => false,
        'discount' => false,
        'employee' => false,
        'workorder_status' => false,
        'workorder_items' => false,
        'workorder_lines' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'workorder_id' => 'workorderID',
        'time_in' => 'timeIn',
        'eta_out' => 'etaOut',
        'note' => 'note',
        'internal_note' => 'internalNote',
        'warranty' => 'warranty',
        'tax' => 'tax',
        'archived' => 'archived',
        'hook_in' => 'hookIn',
        'hook_out' => 'hookOut',
        'save_parts' => 'saveParts',
        'assign_employee_to_all' => 'assignEmployeeToAll',
        'customer_id' => 'customerID',
        'discount_id' => 'discountID',
        'employee_id' => 'employeeID',
        'serialized_id' => 'serializedID',
        'shop_id' => 'shopID',
        'sale_id' => 'saleID',
        'workorder_status_id' => 'workorderStatusID',
        'customer' => 'Customer',
        'discount' => 'Discount',
        'employee' => 'Employee',
        'workorder_status' => 'WorkorderStatus',
        'workorder_items' => 'WorkorderItems',
        'workorder_lines' => 'WorkorderLines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'workorder_id' => 'setWorkorderId',
        'time_in' => 'setTimeIn',
        'eta_out' => 'setEtaOut',
        'note' => 'setNote',
        'internal_note' => 'setInternalNote',
        'warranty' => 'setWarranty',
        'tax' => 'setTax',
        'archived' => 'setArchived',
        'hook_in' => 'setHookIn',
        'hook_out' => 'setHookOut',
        'save_parts' => 'setSaveParts',
        'assign_employee_to_all' => 'setAssignEmployeeToAll',
        'customer_id' => 'setCustomerId',
        'discount_id' => 'setDiscountId',
        'employee_id' => 'setEmployeeId',
        'serialized_id' => 'setSerializedId',
        'shop_id' => 'setShopId',
        'sale_id' => 'setSaleId',
        'workorder_status_id' => 'setWorkorderStatusId',
        'customer' => 'setCustomer',
        'discount' => 'setDiscount',
        'employee' => 'setEmployee',
        'workorder_status' => 'setWorkorderStatus',
        'workorder_items' => 'setWorkorderItems',
        'workorder_lines' => 'setWorkorderLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'workorder_id' => 'getWorkorderId',
        'time_in' => 'getTimeIn',
        'eta_out' => 'getEtaOut',
        'note' => 'getNote',
        'internal_note' => 'getInternalNote',
        'warranty' => 'getWarranty',
        'tax' => 'getTax',
        'archived' => 'getArchived',
        'hook_in' => 'getHookIn',
        'hook_out' => 'getHookOut',
        'save_parts' => 'getSaveParts',
        'assign_employee_to_all' => 'getAssignEmployeeToAll',
        'customer_id' => 'getCustomerId',
        'discount_id' => 'getDiscountId',
        'employee_id' => 'getEmployeeId',
        'serialized_id' => 'getSerializedId',
        'shop_id' => 'getShopId',
        'sale_id' => 'getSaleId',
        'workorder_status_id' => 'getWorkorderStatusId',
        'customer' => 'getCustomer',
        'discount' => 'getDiscount',
        'employee' => 'getEmployee',
        'workorder_status' => 'getWorkorderStatus',
        'workorder_items' => 'getWorkorderItems',
        'workorder_lines' => 'getWorkorderLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('workorder_id', $data ?? [], null);
        $this->setIfExists('time_in', $data ?? [], null);
        $this->setIfExists('eta_out', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('internal_note', $data ?? [], null);
        $this->setIfExists('warranty', $data ?? [], false);
        $this->setIfExists('tax', $data ?? [], true);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('hook_in', $data ?? [], null);
        $this->setIfExists('hook_out', $data ?? [], null);
        $this->setIfExists('save_parts', $data ?? [], false);
        $this->setIfExists('assign_employee_to_all', $data ?? [], false);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('discount_id', $data ?? [], null);
        $this->setIfExists('employee_id', $data ?? [], null);
        $this->setIfExists('serialized_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('sale_id', $data ?? [], null);
        $this->setIfExists('workorder_status_id', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('employee', $data ?? [], null);
        $this->setIfExists('workorder_status', $data ?? [], null);
        $this->setIfExists('workorder_items', $data ?? [], null);
        $this->setIfExists('workorder_lines', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['workorder_id'] === null) {
            $invalidProperties[] = "'workorder_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets workorder_id
     *
     * @return int
     */
    public function getWorkorderId()
    {
        return $this->container['workorder_id'];
    }

    /**
     * Sets workorder_id
     *
     * @param int $workorder_id Unique workorder identifier
     *
     * @return self
     */
    public function setWorkorderId($workorder_id)
    {
        if (is_null($workorder_id)) {
            throw new \InvalidArgumentException('non-nullable workorder_id cannot be null');
        }
        $this->container['workorder_id'] = $workorder_id;

        return $this;
    }

    /**
     * Gets time_in
     *
     * @return \DateTime|null
     */
    public function getTimeIn()
    {
        return $this->container['time_in'];
    }

    /**
     * Sets time_in
     *
     * @param \DateTime|null $time_in Date/time workorder was received
     *
     * @return self
     */
    public function setTimeIn($time_in)
    {
        if (is_null($time_in)) {
            throw new \InvalidArgumentException('non-nullable time_in cannot be null');
        }
        $this->container['time_in'] = $time_in;

        return $this;
    }

    /**
     * Gets eta_out
     *
     * @return \DateTime|null
     */
    public function getEtaOut()
    {
        return $this->container['eta_out'];
    }

    /**
     * Sets eta_out
     *
     * @param \DateTime|null $eta_out Expected completion date/time
     *
     * @return self
     */
    public function setEtaOut($eta_out)
    {
        if (is_null($eta_out)) {
            throw new \InvalidArgumentException('non-nullable eta_out cannot be null');
        }
        $this->container['eta_out'] = $eta_out;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Overall workorder notes
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets internal_note
     *
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->container['internal_note'];
    }

    /**
     * Sets internal_note
     *
     * @param string|null $internal_note Internal workorder notes
     *
     * @return self
     */
    public function setInternalNote($internal_note)
    {
        if (is_null($internal_note)) {
            throw new \InvalidArgumentException('non-nullable internal_note cannot be null');
        }
        $this->container['internal_note'] = $internal_note;

        return $this;
    }

    /**
     * Gets warranty
     *
     * @return bool|null
     */
    public function getWarranty()
    {
        return $this->container['warranty'];
    }

    /**
     * Sets warranty
     *
     * @param bool|null $warranty Indicates if workorder is warranty-covered
     *
     * @return self
     */
    public function setWarranty($warranty)
    {
        if (is_null($warranty)) {
            throw new \InvalidArgumentException('non-nullable warranty cannot be null');
        }
        $this->container['warranty'] = $warranty;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return bool|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param bool|null $tax Whether tax is charged
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived If workorder is hidden
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets hook_in
     *
     * @return string|null
     */
    public function getHookIn()
    {
        return $this->container['hook_in'];
    }

    /**
     * Sets hook_in
     *
     * @param string|null $hook_in Storage location for item before work
     *
     * @return self
     */
    public function setHookIn($hook_in)
    {
        if (is_null($hook_in)) {
            throw new \InvalidArgumentException('non-nullable hook_in cannot be null');
        }
        $this->container['hook_in'] = $hook_in;

        return $this;
    }

    /**
     * Gets hook_out
     *
     * @return string|null
     */
    public function getHookOut()
    {
        return $this->container['hook_out'];
    }

    /**
     * Sets hook_out
     *
     * @param string|null $hook_out Storage location for completed item
     *
     * @return self
     */
    public function setHookOut($hook_out)
    {
        if (is_null($hook_out)) {
            throw new \InvalidArgumentException('non-nullable hook_out cannot be null');
        }
        $this->container['hook_out'] = $hook_out;

        return $this;
    }

    /**
     * Gets save_parts
     *
     * @return bool|null
     */
    public function getSaveParts()
    {
        return $this->container['save_parts'];
    }

    /**
     * Sets save_parts
     *
     * @param bool|null $save_parts Customer wants removed parts saved
     *
     * @return self
     */
    public function setSaveParts($save_parts)
    {
        if (is_null($save_parts)) {
            throw new \InvalidArgumentException('non-nullable save_parts cannot be null');
        }
        $this->container['save_parts'] = $save_parts;

        return $this;
    }

    /**
     * Gets assign_employee_to_all
     *
     * @return bool|null
     */
    public function getAssignEmployeeToAll()
    {
        return $this->container['assign_employee_to_all'];
    }

    /**
     * Sets assign_employee_to_all
     *
     * @param bool|null $assign_employee_to_all Auto-assign employee to all lines
     *
     * @return self
     */
    public function setAssignEmployeeToAll($assign_employee_to_all)
    {
        if (is_null($assign_employee_to_all)) {
            throw new \InvalidArgumentException('non-nullable assign_employee_to_all cannot be null');
        }
        $this->container['assign_employee_to_all'] = $assign_employee_to_all;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Related customer ID
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets discount_id
     *
     * @return int|null
     */
    public function getDiscountId()
    {
        return $this->container['discount_id'];
    }

    /**
     * Sets discount_id
     *
     * @param int|null $discount_id Applied discount ID
     *
     * @return self
     */
    public function setDiscountId($discount_id)
    {
        if (is_null($discount_id)) {
            throw new \InvalidArgumentException('non-nullable discount_id cannot be null');
        }
        $this->container['discount_id'] = $discount_id;

        return $this;
    }

    /**
     * Gets employee_id
     *
     * @return int|null
     */
    public function getEmployeeId()
    {
        return $this->container['employee_id'];
    }

    /**
     * Sets employee_id
     *
     * @param int|null $employee_id Responsible employee ID
     *
     * @return self
     */
    public function setEmployeeId($employee_id)
    {
        if (is_null($employee_id)) {
            throw new \InvalidArgumentException('non-nullable employee_id cannot be null');
        }
        $this->container['employee_id'] = $employee_id;

        return $this;
    }

    /**
     * Gets serialized_id
     *
     * @return int|null
     */
    public function getSerializedId()
    {
        return $this->container['serialized_id'];
    }

    /**
     * Sets serialized_id
     *
     * @param int|null $serialized_id Serialized item being serviced ID
     *
     * @return self
     */
    public function setSerializedId($serialized_id)
    {
        if (is_null($serialized_id)) {
            throw new \InvalidArgumentException('non-nullable serialized_id cannot be null');
        }
        $this->container['serialized_id'] = $serialized_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id Shop performing work ID
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets sale_id
     *
     * @return int|null
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param int|null $sale_id Associated sale ID
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }

    /**
     * Gets workorder_status_id
     *
     * @return int|null
     */
    public function getWorkorderStatusId()
    {
        return $this->container['workorder_status_id'];
    }

    /**
     * Sets workorder_status_id
     *
     * @param int|null $workorder_status_id Current workorder status ID
     *
     * @return self
     */
    public function setWorkorderStatusId($workorder_status_id)
    {
        if (is_null($workorder_status_id)) {
            throw new \InvalidArgumentException('non-nullable workorder_status_id cannot be null');
        }
        $this->container['workorder_status_id'] = $workorder_status_id;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \LightspeedV3\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \LightspeedV3\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return \LightspeedV3\Model\Discount|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param \LightspeedV3\Model\Discount|null $discount discount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets employee
     *
     * @return \LightspeedV3\Model\Employee|null
     */
    public function getEmployee()
    {
        return $this->container['employee'];
    }

    /**
     * Sets employee
     *
     * @param \LightspeedV3\Model\Employee|null $employee employee
     *
     * @return self
     */
    public function setEmployee($employee)
    {
        if (is_null($employee)) {
            throw new \InvalidArgumentException('non-nullable employee cannot be null');
        }
        $this->container['employee'] = $employee;

        return $this;
    }

    /**
     * Gets workorder_status
     *
     * @return \LightspeedV3\Model\WorkorderStatus|null
     */
    public function getWorkorderStatus()
    {
        return $this->container['workorder_status'];
    }

    /**
     * Sets workorder_status
     *
     * @param \LightspeedV3\Model\WorkorderStatus|null $workorder_status workorder_status
     *
     * @return self
     */
    public function setWorkorderStatus($workorder_status)
    {
        if (is_null($workorder_status)) {
            throw new \InvalidArgumentException('non-nullable workorder_status cannot be null');
        }
        $this->container['workorder_status'] = $workorder_status;

        return $this;
    }

    /**
     * Gets workorder_items
     *
     * @return \LightspeedV3\Model\WorkorderWorkorderItems|null
     */
    public function getWorkorderItems()
    {
        return $this->container['workorder_items'];
    }

    /**
     * Sets workorder_items
     *
     * @param \LightspeedV3\Model\WorkorderWorkorderItems|null $workorder_items workorder_items
     *
     * @return self
     */
    public function setWorkorderItems($workorder_items)
    {
        if (is_null($workorder_items)) {
            throw new \InvalidArgumentException('non-nullable workorder_items cannot be null');
        }
        $this->container['workorder_items'] = $workorder_items;

        return $this;
    }

    /**
     * Gets workorder_lines
     *
     * @return \LightspeedV3\Model\WorkorderWorkorderLines|null
     */
    public function getWorkorderLines()
    {
        return $this->container['workorder_lines'];
    }

    /**
     * Sets workorder_lines
     *
     * @param \LightspeedV3\Model\WorkorderWorkorderLines|null $workorder_lines workorder_lines
     *
     * @return self
     */
    public function setWorkorderLines($workorder_lines)
    {
        if (is_null($workorder_lines)) {
            throw new \InvalidArgumentException('non-nullable workorder_lines cannot be null');
        }
        $this->container['workorder_lines'] = $workorder_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


