<?php
/**
 * Vendor
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Vendor Class Doc Comment
 *
 * @category Class
 * @description Vendor information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Vendor implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Vendor';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'vendor_id' => 'int',
        'name' => 'string',
        'archived' => 'bool',
        'account_number' => 'string',
        'price_level' => 'string',
        'update_price' => 'bool',
        'update_cost' => 'bool',
        'update_description' => 'bool',
        'share_sell_through' => 'bool',
        'time_stamp' => '\DateTime',
        'b2b_seller_uid' => 'string',
        'contact' => '\LightspeedV3\Model\Contact',
        'reps' => '\LightspeedV3\Model\VendorReps',
        'purchasing_currency' => '\LightspeedV3\Model\Currency'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'vendor_id' => null,
        'name' => null,
        'archived' => null,
        'account_number' => null,
        'price_level' => null,
        'update_price' => null,
        'update_cost' => null,
        'update_description' => null,
        'share_sell_through' => null,
        'time_stamp' => 'date-time',
        'b2b_seller_uid' => null,
        'contact' => null,
        'reps' => null,
        'purchasing_currency' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'vendor_id' => false,
        'name' => false,
        'archived' => false,
        'account_number' => false,
        'price_level' => false,
        'update_price' => false,
        'update_cost' => false,
        'update_description' => false,
        'share_sell_through' => false,
        'time_stamp' => false,
        'b2b_seller_uid' => false,
        'contact' => false,
        'reps' => false,
        'purchasing_currency' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'vendor_id' => 'vendorID',
        'name' => 'name',
        'archived' => 'archived',
        'account_number' => 'accountNumber',
        'price_level' => 'priceLevel',
        'update_price' => 'updatePrice',
        'update_cost' => 'updateCost',
        'update_description' => 'updateDescription',
        'share_sell_through' => 'shareSellThrough',
        'time_stamp' => 'timeStamp',
        'b2b_seller_uid' => 'b2bSellerUID',
        'contact' => 'Contact',
        'reps' => 'Reps',
        'purchasing_currency' => 'purchasingCurrency'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'vendor_id' => 'setVendorId',
        'name' => 'setName',
        'archived' => 'setArchived',
        'account_number' => 'setAccountNumber',
        'price_level' => 'setPriceLevel',
        'update_price' => 'setUpdatePrice',
        'update_cost' => 'setUpdateCost',
        'update_description' => 'setUpdateDescription',
        'share_sell_through' => 'setShareSellThrough',
        'time_stamp' => 'setTimeStamp',
        'b2b_seller_uid' => 'setB2bSellerUid',
        'contact' => 'setContact',
        'reps' => 'setReps',
        'purchasing_currency' => 'setPurchasingCurrency'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'vendor_id' => 'getVendorId',
        'name' => 'getName',
        'archived' => 'getArchived',
        'account_number' => 'getAccountNumber',
        'price_level' => 'getPriceLevel',
        'update_price' => 'getUpdatePrice',
        'update_cost' => 'getUpdateCost',
        'update_description' => 'getUpdateDescription',
        'share_sell_through' => 'getShareSellThrough',
        'time_stamp' => 'getTimeStamp',
        'b2b_seller_uid' => 'getB2bSellerUid',
        'contact' => 'getContact',
        'reps' => 'getReps',
        'purchasing_currency' => 'getPurchasingCurrency'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('vendor_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('account_number', $data ?? [], null);
        $this->setIfExists('price_level', $data ?? [], null);
        $this->setIfExists('update_price', $data ?? [], false);
        $this->setIfExists('update_cost', $data ?? [], false);
        $this->setIfExists('update_description', $data ?? [], false);
        $this->setIfExists('share_sell_through', $data ?? [], false);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('b2b_seller_uid', $data ?? [], null);
        $this->setIfExists('contact', $data ?? [], null);
        $this->setIfExists('reps', $data ?? [], null);
        $this->setIfExists('purchasing_currency', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['vendor_id'] === null) {
            $invalidProperties[] = "'vendor_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets vendor_id
     *
     * @return int
     */
    public function getVendorId()
    {
        return $this->container['vendor_id'];
    }

    /**
     * Sets vendor_id
     *
     * @param int $vendor_id Unique vendor identifier
     *
     * @return self
     */
    public function setVendorId($vendor_id)
    {
        if (is_null($vendor_id)) {
            throw new \InvalidArgumentException('non-nullable vendor_id cannot be null');
        }
        $this->container['vendor_id'] = $vendor_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Vendor name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Archive status
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets account_number
     *
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->container['account_number'];
    }

    /**
     * Sets account_number
     *
     * @param string|null $account_number Vendor account number
     *
     * @return self
     */
    public function setAccountNumber($account_number)
    {
        if (is_null($account_number)) {
            throw new \InvalidArgumentException('non-nullable account_number cannot be null');
        }
        $this->container['account_number'] = $account_number;

        return $this;
    }

    /**
     * Gets price_level
     *
     * @return string|null
     */
    public function getPriceLevel()
    {
        return $this->container['price_level'];
    }

    /**
     * Sets price_level
     *
     * @param string|null $price_level Pricing tier with vendor
     *
     * @return self
     */
    public function setPriceLevel($price_level)
    {
        if (is_null($price_level)) {
            throw new \InvalidArgumentException('non-nullable price_level cannot be null');
        }
        $this->container['price_level'] = $price_level;

        return $this;
    }

    /**
     * Gets update_price
     *
     * @return bool|null
     */
    public function getUpdatePrice()
    {
        return $this->container['update_price'];
    }

    /**
     * Sets update_price
     *
     * @param bool|null $update_price Auto-update price from catalog
     *
     * @return self
     */
    public function setUpdatePrice($update_price)
    {
        if (is_null($update_price)) {
            throw new \InvalidArgumentException('non-nullable update_price cannot be null');
        }
        $this->container['update_price'] = $update_price;

        return $this;
    }

    /**
     * Gets update_cost
     *
     * @return bool|null
     */
    public function getUpdateCost()
    {
        return $this->container['update_cost'];
    }

    /**
     * Sets update_cost
     *
     * @param bool|null $update_cost Auto-update cost from catalog
     *
     * @return self
     */
    public function setUpdateCost($update_cost)
    {
        if (is_null($update_cost)) {
            throw new \InvalidArgumentException('non-nullable update_cost cannot be null');
        }
        $this->container['update_cost'] = $update_cost;

        return $this;
    }

    /**
     * Gets update_description
     *
     * @return bool|null
     */
    public function getUpdateDescription()
    {
        return $this->container['update_description'];
    }

    /**
     * Sets update_description
     *
     * @param bool|null $update_description Auto-update description from catalog
     *
     * @return self
     */
    public function setUpdateDescription($update_description)
    {
        if (is_null($update_description)) {
            throw new \InvalidArgumentException('non-nullable update_description cannot be null');
        }
        $this->container['update_description'] = $update_description;

        return $this;
    }

    /**
     * Gets share_sell_through
     *
     * @return bool|null
     */
    public function getShareSellThrough()
    {
        return $this->container['share_sell_through'];
    }

    /**
     * Sets share_sell_through
     *
     * @param bool|null $share_sell_through Allow vendor to share sell-through data
     *
     * @return self
     */
    public function setShareSellThrough($share_sell_through)
    {
        if (is_null($share_sell_through)) {
            throw new \InvalidArgumentException('non-nullable share_sell_through cannot be null');
        }
        $this->container['share_sell_through'] = $share_sell_through;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification date/time
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets b2b_seller_uid
     *
     * @return string|null
     */
    public function getB2bSellerUid()
    {
        return $this->container['b2b_seller_uid'];
    }

    /**
     * Sets b2b_seller_uid
     *
     * @param string|null $b2b_seller_uid Unique identifier in NuORDER
     *
     * @return self
     */
    public function setB2bSellerUid($b2b_seller_uid)
    {
        if (is_null($b2b_seller_uid)) {
            throw new \InvalidArgumentException('non-nullable b2b_seller_uid cannot be null');
        }
        $this->container['b2b_seller_uid'] = $b2b_seller_uid;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \LightspeedV3\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \LightspeedV3\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        if (is_null($contact)) {
            throw new \InvalidArgumentException('non-nullable contact cannot be null');
        }
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets reps
     *
     * @return \LightspeedV3\Model\VendorReps|null
     */
    public function getReps()
    {
        return $this->container['reps'];
    }

    /**
     * Sets reps
     *
     * @param \LightspeedV3\Model\VendorReps|null $reps reps
     *
     * @return self
     */
    public function setReps($reps)
    {
        if (is_null($reps)) {
            throw new \InvalidArgumentException('non-nullable reps cannot be null');
        }
        $this->container['reps'] = $reps;

        return $this;
    }

    /**
     * Gets purchasing_currency
     *
     * @return \LightspeedV3\Model\Currency|null
     */
    public function getPurchasingCurrency()
    {
        return $this->container['purchasing_currency'];
    }

    /**
     * Sets purchasing_currency
     *
     * @param \LightspeedV3\Model\Currency|null $purchasing_currency purchasing_currency
     *
     * @return self
     */
    public function setPurchasingCurrency($purchasing_currency)
    {
        if (is_null($purchasing_currency)) {
            throw new \InvalidArgumentException('non-nullable purchasing_currency cannot be null');
        }
        $this->container['purchasing_currency'] = $purchasing_currency;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


