<?php
/**
 * TaxCategory
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * TaxCategory Class Doc Comment
 *
 * @category Class
 * @description Tax category information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TaxCategory implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxCategory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_category_id' => 'int',
        'is_tax_inclusive' => 'bool',
        'tax1_name' => 'string',
        'tax2_name' => 'string',
        'tax1_rate' => 'float',
        'tax2_rate' => 'float',
        'time_stamp' => '\DateTime',
        'tax_category_classes' => '\LightspeedV3\Model\TaxCategoryTaxCategoryClasses'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_category_id' => null,
        'is_tax_inclusive' => null,
        'tax1_name' => null,
        'tax2_name' => null,
        'tax1_rate' => 'float',
        'tax2_rate' => 'float',
        'time_stamp' => 'date-time',
        'tax_category_classes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'tax_category_id' => false,
        'is_tax_inclusive' => false,
        'tax1_name' => false,
        'tax2_name' => false,
        'tax1_rate' => false,
        'tax2_rate' => false,
        'time_stamp' => false,
        'tax_category_classes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_category_id' => 'taxCategoryID',
        'is_tax_inclusive' => 'isTaxInclusive',
        'tax1_name' => 'tax1Name',
        'tax2_name' => 'tax2Name',
        'tax1_rate' => 'tax1Rate',
        'tax2_rate' => 'tax2Rate',
        'time_stamp' => 'timeStamp',
        'tax_category_classes' => 'TaxCategoryClasses'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_category_id' => 'setTaxCategoryId',
        'is_tax_inclusive' => 'setIsTaxInclusive',
        'tax1_name' => 'setTax1Name',
        'tax2_name' => 'setTax2Name',
        'tax1_rate' => 'setTax1Rate',
        'tax2_rate' => 'setTax2Rate',
        'time_stamp' => 'setTimeStamp',
        'tax_category_classes' => 'setTaxCategoryClasses'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_category_id' => 'getTaxCategoryId',
        'is_tax_inclusive' => 'getIsTaxInclusive',
        'tax1_name' => 'getTax1Name',
        'tax2_name' => 'getTax2Name',
        'tax1_rate' => 'getTax1Rate',
        'tax2_rate' => 'getTax2Rate',
        'time_stamp' => 'getTimeStamp',
        'tax_category_classes' => 'getTaxCategoryClasses'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('tax_category_id', $data ?? [], null);
        $this->setIfExists('is_tax_inclusive', $data ?? [], false);
        $this->setIfExists('tax1_name', $data ?? [], null);
        $this->setIfExists('tax2_name', $data ?? [], null);
        $this->setIfExists('tax1_rate', $data ?? [], null);
        $this->setIfExists('tax2_rate', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('tax_category_classes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['tax_category_id'] === null) {
            $invalidProperties[] = "'tax_category_id' can't be null";
        }
        if ($this->container['tax1_name'] === null) {
            $invalidProperties[] = "'tax1_name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_category_id
     *
     * @return int
     */
    public function getTaxCategoryId()
    {
        return $this->container['tax_category_id'];
    }

    /**
     * Sets tax_category_id
     *
     * @param int $tax_category_id Unique tax category identifier
     *
     * @return self
     */
    public function setTaxCategoryId($tax_category_id)
    {
        if (is_null($tax_category_id)) {
            throw new \InvalidArgumentException('non-nullable tax_category_id cannot be null');
        }
        $this->container['tax_category_id'] = $tax_category_id;

        return $this;
    }

    /**
     * Gets is_tax_inclusive
     *
     * @return bool|null
     */
    public function getIsTaxInclusive()
    {
        return $this->container['is_tax_inclusive'];
    }

    /**
     * Sets is_tax_inclusive
     *
     * @param bool|null $is_tax_inclusive Indicates if tax is included in pricing
     *
     * @return self
     */
    public function setIsTaxInclusive($is_tax_inclusive)
    {
        if (is_null($is_tax_inclusive)) {
            throw new \InvalidArgumentException('non-nullable is_tax_inclusive cannot be null');
        }
        $this->container['is_tax_inclusive'] = $is_tax_inclusive;

        return $this;
    }

    /**
     * Gets tax1_name
     *
     * @return string
     */
    public function getTax1Name()
    {
        return $this->container['tax1_name'];
    }

    /**
     * Sets tax1_name
     *
     * @param string $tax1_name Name of first tax rate
     *
     * @return self
     */
    public function setTax1Name($tax1_name)
    {
        if (is_null($tax1_name)) {
            throw new \InvalidArgumentException('non-nullable tax1_name cannot be null');
        }
        $this->container['tax1_name'] = $tax1_name;

        return $this;
    }

    /**
     * Gets tax2_name
     *
     * @return string|null
     */
    public function getTax2Name()
    {
        return $this->container['tax2_name'];
    }

    /**
     * Sets tax2_name
     *
     * @param string|null $tax2_name Name of second tax rate
     *
     * @return self
     */
    public function setTax2Name($tax2_name)
    {
        if (is_null($tax2_name)) {
            throw new \InvalidArgumentException('non-nullable tax2_name cannot be null');
        }
        $this->container['tax2_name'] = $tax2_name;

        return $this;
    }

    /**
     * Gets tax1_rate
     *
     * @return float|null
     */
    public function getTax1Rate()
    {
        return $this->container['tax1_rate'];
    }

    /**
     * Sets tax1_rate
     *
     * @param float|null $tax1_rate First tax rate percentage
     *
     * @return self
     */
    public function setTax1Rate($tax1_rate)
    {
        if (is_null($tax1_rate)) {
            throw new \InvalidArgumentException('non-nullable tax1_rate cannot be null');
        }
        $this->container['tax1_rate'] = $tax1_rate;

        return $this;
    }

    /**
     * Gets tax2_rate
     *
     * @return float|null
     */
    public function getTax2Rate()
    {
        return $this->container['tax2_rate'];
    }

    /**
     * Sets tax2_rate
     *
     * @param float|null $tax2_rate Second tax rate percentage
     *
     * @return self
     */
    public function setTax2Rate($tax2_rate)
    {
        if (is_null($tax2_rate)) {
            throw new \InvalidArgumentException('non-nullable tax2_rate cannot be null');
        }
        $this->container['tax2_rate'] = $tax2_rate;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification date/time
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets tax_category_classes
     *
     * @return \LightspeedV3\Model\TaxCategoryTaxCategoryClasses|null
     */
    public function getTaxCategoryClasses()
    {
        return $this->container['tax_category_classes'];
    }

    /**
     * Sets tax_category_classes
     *
     * @param \LightspeedV3\Model\TaxCategoryTaxCategoryClasses|null $tax_category_classes tax_category_classes
     *
     * @return self
     */
    public function setTaxCategoryClasses($tax_category_classes)
    {
        if (is_null($tax_category_classes)) {
            throw new \InvalidArgumentException('non-nullable tax_category_classes cannot be null');
        }
        $this->container['tax_category_classes'] = $tax_category_classes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


