<?php
/**
 * Shop
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Shop Class Doc Comment
 *
 * @category Class
 * @description Shop information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Shop implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Shop';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shop_id' => 'int',
        'name' => 'string',
        'service_rate' => 'float',
        'time_zone' => 'string',
        'tax_labor' => 'bool',
        'label_title' => 'string',
        'label_msrp' => 'bool',
        'archived' => 'bool',
        'create_time' => '\DateTime',
        'time_stamp' => '\DateTime',
        'contact' => '\LightspeedV3\Model\Contact',
        'tax_category' => '\LightspeedV3\Model\TaxCategory',
        'price_level' => '\LightspeedV3\Model\PriceLevel'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shop_id' => null,
        'name' => null,
        'service_rate' => 'float',
        'time_zone' => null,
        'tax_labor' => null,
        'label_title' => null,
        'label_msrp' => null,
        'archived' => null,
        'create_time' => 'date-time',
        'time_stamp' => 'date-time',
        'contact' => null,
        'tax_category' => null,
        'price_level' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shop_id' => false,
        'name' => false,
        'service_rate' => false,
        'time_zone' => false,
        'tax_labor' => false,
        'label_title' => false,
        'label_msrp' => false,
        'archived' => false,
        'create_time' => false,
        'time_stamp' => false,
        'contact' => false,
        'tax_category' => false,
        'price_level' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shop_id' => 'shopID',
        'name' => 'name',
        'service_rate' => 'serviceRate',
        'time_zone' => 'timeZone',
        'tax_labor' => 'taxLabor',
        'label_title' => 'labelTitle',
        'label_msrp' => 'labelMsrp',
        'archived' => 'archived',
        'create_time' => 'createTime',
        'time_stamp' => 'timeStamp',
        'contact' => 'Contact',
        'tax_category' => 'TaxCategory',
        'price_level' => 'PriceLevel'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shop_id' => 'setShopId',
        'name' => 'setName',
        'service_rate' => 'setServiceRate',
        'time_zone' => 'setTimeZone',
        'tax_labor' => 'setTaxLabor',
        'label_title' => 'setLabelTitle',
        'label_msrp' => 'setLabelMsrp',
        'archived' => 'setArchived',
        'create_time' => 'setCreateTime',
        'time_stamp' => 'setTimeStamp',
        'contact' => 'setContact',
        'tax_category' => 'setTaxCategory',
        'price_level' => 'setPriceLevel'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shop_id' => 'getShopId',
        'name' => 'getName',
        'service_rate' => 'getServiceRate',
        'time_zone' => 'getTimeZone',
        'tax_labor' => 'getTaxLabor',
        'label_title' => 'getLabelTitle',
        'label_msrp' => 'getLabelMsrp',
        'archived' => 'getArchived',
        'create_time' => 'getCreateTime',
        'time_stamp' => 'getTimeStamp',
        'contact' => 'getContact',
        'tax_category' => 'getTaxCategory',
        'price_level' => 'getPriceLevel'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('service_rate', $data ?? [], null);
        $this->setIfExists('time_zone', $data ?? [], null);
        $this->setIfExists('tax_labor', $data ?? [], false);
        $this->setIfExists('label_title', $data ?? [], null);
        $this->setIfExists('label_msrp', $data ?? [], false);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('contact', $data ?? [], null);
        $this->setIfExists('tax_category', $data ?? [], null);
        $this->setIfExists('price_level', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['shop_id'] === null) {
            $invalidProperties[] = "'shop_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shop_id
     *
     * @return int
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int $shop_id Unique shop identifier
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Shop name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets service_rate
     *
     * @return float|null
     */
    public function getServiceRate()
    {
        return $this->container['service_rate'];
    }

    /**
     * Sets service_rate
     *
     * @param float|null $service_rate Hourly service rate
     *
     * @return self
     */
    public function setServiceRate($service_rate)
    {
        if (is_null($service_rate)) {
            throw new \InvalidArgumentException('non-nullable service_rate cannot be null');
        }
        $this->container['service_rate'] = $service_rate;

        return $this;
    }

    /**
     * Gets time_zone
     *
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     *
     * @param string|null $time_zone Shop's timezone
     *
     * @return self
     */
    public function setTimeZone($time_zone)
    {
        if (is_null($time_zone)) {
            throw new \InvalidArgumentException('non-nullable time_zone cannot be null');
        }
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets tax_labor
     *
     * @return bool|null
     */
    public function getTaxLabor()
    {
        return $this->container['tax_labor'];
    }

    /**
     * Sets tax_labor
     *
     * @param bool|null $tax_labor Whether service/labor has sales tax
     *
     * @return self
     */
    public function setTaxLabor($tax_labor)
    {
        if (is_null($tax_labor)) {
            throw new \InvalidArgumentException('non-nullable tax_labor cannot be null');
        }
        $this->container['tax_labor'] = $tax_labor;

        return $this;
    }

    /**
     * Gets label_title
     *
     * @return string|null
     */
    public function getLabelTitle()
    {
        return $this->container['label_title'];
    }

    /**
     * Sets label_title
     *
     * @param string|null $label_title Product label title options
     *
     * @return self
     */
    public function setLabelTitle($label_title)
    {
        if (is_null($label_title)) {
            throw new \InvalidArgumentException('non-nullable label_title cannot be null');
        }
        $this->container['label_title'] = $label_title;

        return $this;
    }

    /**
     * Gets label_msrp
     *
     * @return bool|null
     */
    public function getLabelMsrp()
    {
        return $this->container['label_msrp'];
    }

    /**
     * Sets label_msrp
     *
     * @param bool|null $label_msrp Whether to include MSRP on labels
     *
     * @return self
     */
    public function setLabelMsrp($label_msrp)
    {
        if (is_null($label_msrp)) {
            throw new \InvalidArgumentException('non-nullable label_msrp cannot be null');
        }
        $this->container['label_msrp'] = $label_msrp;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Shop's archival status
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return \DateTime|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param \DateTime|null $create_time Record creation timestamp
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Last modification timestamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \LightspeedV3\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \LightspeedV3\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        if (is_null($contact)) {
            throw new \InvalidArgumentException('non-nullable contact cannot be null');
        }
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets tax_category
     *
     * @return \LightspeedV3\Model\TaxCategory|null
     */
    public function getTaxCategory()
    {
        return $this->container['tax_category'];
    }

    /**
     * Sets tax_category
     *
     * @param \LightspeedV3\Model\TaxCategory|null $tax_category tax_category
     *
     * @return self
     */
    public function setTaxCategory($tax_category)
    {
        if (is_null($tax_category)) {
            throw new \InvalidArgumentException('non-nullable tax_category cannot be null');
        }
        $this->container['tax_category'] = $tax_category;

        return $this;
    }

    /**
     * Gets price_level
     *
     * @return \LightspeedV3\Model\PriceLevel|null
     */
    public function getPriceLevel()
    {
        return $this->container['price_level'];
    }

    /**
     * Sets price_level
     *
     * @param \LightspeedV3\Model\PriceLevel|null $price_level price_level
     *
     * @return self
     */
    public function setPriceLevel($price_level)
    {
        if (is_null($price_level)) {
            throw new \InvalidArgumentException('non-nullable price_level cannot be null');
        }
        $this->container['price_level'] = $price_level;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


