<?php
/**
 * SalePayment
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * SalePayment Class Doc Comment
 *
 * @category Class
 * @description Sale payment information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SalePayment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SalePayment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sale_payment_id' => 'int',
        'amount' => 'float',
        'create_time' => '\DateTime',
        'archived' => 'bool',
        'tip_amount' => 'float',
        'remote_reference' => 'string',
        'payment_id' => 'string',
        'payment_type_id' => 'int',
        'sale_id' => 'int',
        'register_id' => 'int',
        'employee_id' => 'int',
        'cc_charge_id' => 'int',
        'credit_account_id' => 'int',
        'payment_type' => '\LightspeedV3\Model\PaymentType',
        'cc_charge' => '\LightspeedV3\Model\CCCharge'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sale_payment_id' => null,
        'amount' => 'float',
        'create_time' => 'date-time',
        'archived' => null,
        'tip_amount' => 'float',
        'remote_reference' => null,
        'payment_id' => null,
        'payment_type_id' => null,
        'sale_id' => null,
        'register_id' => null,
        'employee_id' => null,
        'cc_charge_id' => null,
        'credit_account_id' => null,
        'payment_type' => null,
        'cc_charge' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sale_payment_id' => false,
        'amount' => false,
        'create_time' => false,
        'archived' => false,
        'tip_amount' => false,
        'remote_reference' => false,
        'payment_id' => false,
        'payment_type_id' => false,
        'sale_id' => false,
        'register_id' => false,
        'employee_id' => false,
        'cc_charge_id' => false,
        'credit_account_id' => false,
        'payment_type' => false,
        'cc_charge' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sale_payment_id' => 'salePaymentID',
        'amount' => 'amount',
        'create_time' => 'createTime',
        'archived' => 'archived',
        'tip_amount' => 'tipAmount',
        'remote_reference' => 'remoteReference',
        'payment_id' => 'paymentID',
        'payment_type_id' => 'paymentTypeID',
        'sale_id' => 'saleID',
        'register_id' => 'registerID',
        'employee_id' => 'employeeID',
        'cc_charge_id' => 'ccChargeID',
        'credit_account_id' => 'creditAccountID',
        'payment_type' => 'PaymentType',
        'cc_charge' => 'CCCharge'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sale_payment_id' => 'setSalePaymentId',
        'amount' => 'setAmount',
        'create_time' => 'setCreateTime',
        'archived' => 'setArchived',
        'tip_amount' => 'setTipAmount',
        'remote_reference' => 'setRemoteReference',
        'payment_id' => 'setPaymentId',
        'payment_type_id' => 'setPaymentTypeId',
        'sale_id' => 'setSaleId',
        'register_id' => 'setRegisterId',
        'employee_id' => 'setEmployeeId',
        'cc_charge_id' => 'setCcChargeId',
        'credit_account_id' => 'setCreditAccountId',
        'payment_type' => 'setPaymentType',
        'cc_charge' => 'setCcCharge'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sale_payment_id' => 'getSalePaymentId',
        'amount' => 'getAmount',
        'create_time' => 'getCreateTime',
        'archived' => 'getArchived',
        'tip_amount' => 'getTipAmount',
        'remote_reference' => 'getRemoteReference',
        'payment_id' => 'getPaymentId',
        'payment_type_id' => 'getPaymentTypeId',
        'sale_id' => 'getSaleId',
        'register_id' => 'getRegisterId',
        'employee_id' => 'getEmployeeId',
        'cc_charge_id' => 'getCcChargeId',
        'credit_account_id' => 'getCreditAccountId',
        'payment_type' => 'getPaymentType',
        'cc_charge' => 'getCcCharge'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sale_payment_id', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('tip_amount', $data ?? [], null);
        $this->setIfExists('remote_reference', $data ?? [], null);
        $this->setIfExists('payment_id', $data ?? [], null);
        $this->setIfExists('payment_type_id', $data ?? [], null);
        $this->setIfExists('sale_id', $data ?? [], null);
        $this->setIfExists('register_id', $data ?? [], null);
        $this->setIfExists('employee_id', $data ?? [], null);
        $this->setIfExists('cc_charge_id', $data ?? [], null);
        $this->setIfExists('credit_account_id', $data ?? [], null);
        $this->setIfExists('payment_type', $data ?? [], null);
        $this->setIfExists('cc_charge', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sale_payment_id'] === null) {
            $invalidProperties[] = "'sale_payment_id' can't be null";
        }
        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sale_payment_id
     *
     * @return int
     */
    public function getSalePaymentId()
    {
        return $this->container['sale_payment_id'];
    }

    /**
     * Sets sale_payment_id
     *
     * @param int $sale_payment_id Unique payment identifier
     *
     * @return self
     */
    public function setSalePaymentId($sale_payment_id)
    {
        if (is_null($sale_payment_id)) {
            throw new \InvalidArgumentException('non-nullable sale_payment_id cannot be null');
        }
        $this->container['sale_payment_id'] = $sale_payment_id;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float $amount Payment amount (including tip)
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return \DateTime|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param \DateTime|null $create_time Date/time payment was made
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Indicates if payment is archived/voided
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets tip_amount
     *
     * @return float|null
     */
    public function getTipAmount()
    {
        return $this->container['tip_amount'];
    }

    /**
     * Sets tip_amount
     *
     * @param float|null $tip_amount Tip amount (negative for refunds)
     *
     * @return self
     */
    public function setTipAmount($tip_amount)
    {
        if (is_null($tip_amount)) {
            throw new \InvalidArgumentException('non-nullable tip_amount cannot be null');
        }
        $this->container['tip_amount'] = $tip_amount;

        return $this;
    }

    /**
     * Gets remote_reference
     *
     * @return string|null
     */
    public function getRemoteReference()
    {
        return $this->container['remote_reference'];
    }

    /**
     * Sets remote_reference
     *
     * @param string|null $remote_reference External payment reference
     *
     * @return self
     */
    public function setRemoteReference($remote_reference)
    {
        if (is_null($remote_reference)) {
            throw new \InvalidArgumentException('non-nullable remote_reference cannot be null');
        }
        $this->container['remote_reference'] = $remote_reference;

        return $this;
    }

    /**
     * Gets payment_id
     *
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param string|null $payment_id Payment identifier
     *
     * @return self
     */
    public function setPaymentId($payment_id)
    {
        if (is_null($payment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_id cannot be null');
        }
        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets payment_type_id
     *
     * @return int|null
     */
    public function getPaymentTypeId()
    {
        return $this->container['payment_type_id'];
    }

    /**
     * Sets payment_type_id
     *
     * @param int|null $payment_type_id Foreign key to PaymentType
     *
     * @return self
     */
    public function setPaymentTypeId($payment_type_id)
    {
        if (is_null($payment_type_id)) {
            throw new \InvalidArgumentException('non-nullable payment_type_id cannot be null');
        }
        $this->container['payment_type_id'] = $payment_type_id;

        return $this;
    }

    /**
     * Gets sale_id
     *
     * @return int|null
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param int|null $sale_id Foreign key to associated Sale
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return int|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param int|null $register_id Foreign key to Register
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        if (is_null($register_id)) {
            throw new \InvalidArgumentException('non-nullable register_id cannot be null');
        }
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets employee_id
     *
     * @return int|null
     */
    public function getEmployeeId()
    {
        return $this->container['employee_id'];
    }

    /**
     * Sets employee_id
     *
     * @param int|null $employee_id Foreign key to Employee
     *
     * @return self
     */
    public function setEmployeeId($employee_id)
    {
        if (is_null($employee_id)) {
            throw new \InvalidArgumentException('non-nullable employee_id cannot be null');
        }
        $this->container['employee_id'] = $employee_id;

        return $this;
    }

    /**
     * Gets cc_charge_id
     *
     * @return int|null
     */
    public function getCcChargeId()
    {
        return $this->container['cc_charge_id'];
    }

    /**
     * Sets cc_charge_id
     *
     * @param int|null $cc_charge_id Foreign key to CCCharge
     *
     * @return self
     */
    public function setCcChargeId($cc_charge_id)
    {
        if (is_null($cc_charge_id)) {
            throw new \InvalidArgumentException('non-nullable cc_charge_id cannot be null');
        }
        $this->container['cc_charge_id'] = $cc_charge_id;

        return $this;
    }

    /**
     * Gets credit_account_id
     *
     * @return int|null
     */
    public function getCreditAccountId()
    {
        return $this->container['credit_account_id'];
    }

    /**
     * Sets credit_account_id
     *
     * @param int|null $credit_account_id Foreign key to credit account
     *
     * @return self
     */
    public function setCreditAccountId($credit_account_id)
    {
        if (is_null($credit_account_id)) {
            throw new \InvalidArgumentException('non-nullable credit_account_id cannot be null');
        }
        $this->container['credit_account_id'] = $credit_account_id;

        return $this;
    }

    /**
     * Gets payment_type
     *
     * @return \LightspeedV3\Model\PaymentType|null
     */
    public function getPaymentType()
    {
        return $this->container['payment_type'];
    }

    /**
     * Sets payment_type
     *
     * @param \LightspeedV3\Model\PaymentType|null $payment_type payment_type
     *
     * @return self
     */
    public function setPaymentType($payment_type)
    {
        if (is_null($payment_type)) {
            throw new \InvalidArgumentException('non-nullable payment_type cannot be null');
        }
        $this->container['payment_type'] = $payment_type;

        return $this;
    }

    /**
     * Gets cc_charge
     *
     * @return \LightspeedV3\Model\CCCharge|null
     */
    public function getCcCharge()
    {
        return $this->container['cc_charge'];
    }

    /**
     * Sets cc_charge
     *
     * @param \LightspeedV3\Model\CCCharge|null $cc_charge cc_charge
     *
     * @return self
     */
    public function setCcCharge($cc_charge)
    {
        if (is_null($cc_charge)) {
            throw new \InvalidArgumentException('non-nullable cc_charge cannot be null');
        }
        $this->container['cc_charge'] = $cc_charge;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


