<?php
/**
 * SaleLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * SaleLine Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SaleLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SaleLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sale_line_id' => 'string',
        'create_time' => 'string',
        'time_stamp' => 'string',
        'unit_quantity' => 'string',
        'unit_price' => 'string',
        'normal_unit_price' => 'string',
        'discount_amount' => 'string',
        'discount_percent' => 'string',
        'avg_cost' => 'string',
        'fifo_cost' => 'string',
        'tax' => 'string',
        'tax1_rate' => 'string',
        'tax2_rate' => 'string',
        'is_layaway' => 'string',
        'is_workorder' => 'string',
        'is_special_order' => 'string',
        'displayable_subtotal' => 'string',
        'displayable_unit_price' => 'string',
        'calc_line_discount' => 'string',
        'calc_transaction_discount' => 'string',
        'calc_total' => 'string',
        'calc_subtotal' => 'string',
        'calc_tax1' => 'string',
        'calc_tax2' => 'string',
        'tax_class_id' => 'string',
        'customer_id' => 'string',
        'discount_id' => 'string',
        'employee_id' => 'string',
        'item_id' => 'string',
        'note_id' => 'string',
        'parent_sale_line_id' => 'string',
        'shop_id' => 'string',
        'tax_category_id' => 'string',
        'sale_id' => 'string',
        'tax_class' => '\LightspeedV3\Model\TaxClass',
        'discount' => '\LightspeedV3\Model\Discount',
        'tax_category' => '\LightspeedV3\Model\TaxCategory',
        'sales_accounts' => '\LightspeedV3\Model\SaleLineSalesAccounts',
        'item' => '\LightspeedV3\Model\Item'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sale_line_id' => null,
        'create_time' => null,
        'time_stamp' => null,
        'unit_quantity' => null,
        'unit_price' => null,
        'normal_unit_price' => null,
        'discount_amount' => null,
        'discount_percent' => null,
        'avg_cost' => null,
        'fifo_cost' => null,
        'tax' => null,
        'tax1_rate' => null,
        'tax2_rate' => null,
        'is_layaway' => null,
        'is_workorder' => null,
        'is_special_order' => null,
        'displayable_subtotal' => null,
        'displayable_unit_price' => null,
        'calc_line_discount' => null,
        'calc_transaction_discount' => null,
        'calc_total' => null,
        'calc_subtotal' => null,
        'calc_tax1' => null,
        'calc_tax2' => null,
        'tax_class_id' => null,
        'customer_id' => null,
        'discount_id' => null,
        'employee_id' => null,
        'item_id' => null,
        'note_id' => null,
        'parent_sale_line_id' => null,
        'shop_id' => null,
        'tax_category_id' => null,
        'sale_id' => null,
        'tax_class' => null,
        'discount' => null,
        'tax_category' => null,
        'sales_accounts' => null,
        'item' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sale_line_id' => false,
        'create_time' => false,
        'time_stamp' => false,
        'unit_quantity' => false,
        'unit_price' => false,
        'normal_unit_price' => false,
        'discount_amount' => false,
        'discount_percent' => false,
        'avg_cost' => false,
        'fifo_cost' => false,
        'tax' => false,
        'tax1_rate' => false,
        'tax2_rate' => false,
        'is_layaway' => false,
        'is_workorder' => false,
        'is_special_order' => false,
        'displayable_subtotal' => false,
        'displayable_unit_price' => false,
        'calc_line_discount' => false,
        'calc_transaction_discount' => false,
        'calc_total' => false,
        'calc_subtotal' => false,
        'calc_tax1' => false,
        'calc_tax2' => false,
        'tax_class_id' => false,
        'customer_id' => false,
        'discount_id' => false,
        'employee_id' => false,
        'item_id' => false,
        'note_id' => false,
        'parent_sale_line_id' => false,
        'shop_id' => false,
        'tax_category_id' => false,
        'sale_id' => false,
        'tax_class' => false,
        'discount' => false,
        'tax_category' => false,
        'sales_accounts' => false,
        'item' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sale_line_id' => 'saleLineID',
        'create_time' => 'createTime',
        'time_stamp' => 'timeStamp',
        'unit_quantity' => 'unitQuantity',
        'unit_price' => 'unitPrice',
        'normal_unit_price' => 'normalUnitPrice',
        'discount_amount' => 'discountAmount',
        'discount_percent' => 'discountPercent',
        'avg_cost' => 'avgCost',
        'fifo_cost' => 'fifoCost',
        'tax' => 'tax',
        'tax1_rate' => 'tax1Rate',
        'tax2_rate' => 'tax2Rate',
        'is_layaway' => 'isLayaway',
        'is_workorder' => 'isWorkorder',
        'is_special_order' => 'isSpecialOrder',
        'displayable_subtotal' => 'displayableSubtotal',
        'displayable_unit_price' => 'displayableUnitPrice',
        'calc_line_discount' => 'calcLineDiscount',
        'calc_transaction_discount' => 'calcTransactionDiscount',
        'calc_total' => 'calcTotal',
        'calc_subtotal' => 'calcSubtotal',
        'calc_tax1' => 'calcTax1',
        'calc_tax2' => 'calcTax2',
        'tax_class_id' => 'taxClassID',
        'customer_id' => 'customerID',
        'discount_id' => 'discountID',
        'employee_id' => 'employeeID',
        'item_id' => 'itemID',
        'note_id' => 'noteID',
        'parent_sale_line_id' => 'parentSaleLineID',
        'shop_id' => 'shopID',
        'tax_category_id' => 'taxCategoryID',
        'sale_id' => 'saleID',
        'tax_class' => 'TaxClass',
        'discount' => 'Discount',
        'tax_category' => 'TaxCategory',
        'sales_accounts' => 'SalesAccounts',
        'item' => 'Item'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sale_line_id' => 'setSaleLineId',
        'create_time' => 'setCreateTime',
        'time_stamp' => 'setTimeStamp',
        'unit_quantity' => 'setUnitQuantity',
        'unit_price' => 'setUnitPrice',
        'normal_unit_price' => 'setNormalUnitPrice',
        'discount_amount' => 'setDiscountAmount',
        'discount_percent' => 'setDiscountPercent',
        'avg_cost' => 'setAvgCost',
        'fifo_cost' => 'setFifoCost',
        'tax' => 'setTax',
        'tax1_rate' => 'setTax1Rate',
        'tax2_rate' => 'setTax2Rate',
        'is_layaway' => 'setIsLayaway',
        'is_workorder' => 'setIsWorkorder',
        'is_special_order' => 'setIsSpecialOrder',
        'displayable_subtotal' => 'setDisplayableSubtotal',
        'displayable_unit_price' => 'setDisplayableUnitPrice',
        'calc_line_discount' => 'setCalcLineDiscount',
        'calc_transaction_discount' => 'setCalcTransactionDiscount',
        'calc_total' => 'setCalcTotal',
        'calc_subtotal' => 'setCalcSubtotal',
        'calc_tax1' => 'setCalcTax1',
        'calc_tax2' => 'setCalcTax2',
        'tax_class_id' => 'setTaxClassId',
        'customer_id' => 'setCustomerId',
        'discount_id' => 'setDiscountId',
        'employee_id' => 'setEmployeeId',
        'item_id' => 'setItemId',
        'note_id' => 'setNoteId',
        'parent_sale_line_id' => 'setParentSaleLineId',
        'shop_id' => 'setShopId',
        'tax_category_id' => 'setTaxCategoryId',
        'sale_id' => 'setSaleId',
        'tax_class' => 'setTaxClass',
        'discount' => 'setDiscount',
        'tax_category' => 'setTaxCategory',
        'sales_accounts' => 'setSalesAccounts',
        'item' => 'setItem'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sale_line_id' => 'getSaleLineId',
        'create_time' => 'getCreateTime',
        'time_stamp' => 'getTimeStamp',
        'unit_quantity' => 'getUnitQuantity',
        'unit_price' => 'getUnitPrice',
        'normal_unit_price' => 'getNormalUnitPrice',
        'discount_amount' => 'getDiscountAmount',
        'discount_percent' => 'getDiscountPercent',
        'avg_cost' => 'getAvgCost',
        'fifo_cost' => 'getFifoCost',
        'tax' => 'getTax',
        'tax1_rate' => 'getTax1Rate',
        'tax2_rate' => 'getTax2Rate',
        'is_layaway' => 'getIsLayaway',
        'is_workorder' => 'getIsWorkorder',
        'is_special_order' => 'getIsSpecialOrder',
        'displayable_subtotal' => 'getDisplayableSubtotal',
        'displayable_unit_price' => 'getDisplayableUnitPrice',
        'calc_line_discount' => 'getCalcLineDiscount',
        'calc_transaction_discount' => 'getCalcTransactionDiscount',
        'calc_total' => 'getCalcTotal',
        'calc_subtotal' => 'getCalcSubtotal',
        'calc_tax1' => 'getCalcTax1',
        'calc_tax2' => 'getCalcTax2',
        'tax_class_id' => 'getTaxClassId',
        'customer_id' => 'getCustomerId',
        'discount_id' => 'getDiscountId',
        'employee_id' => 'getEmployeeId',
        'item_id' => 'getItemId',
        'note_id' => 'getNoteId',
        'parent_sale_line_id' => 'getParentSaleLineId',
        'shop_id' => 'getShopId',
        'tax_category_id' => 'getTaxCategoryId',
        'sale_id' => 'getSaleId',
        'tax_class' => 'getTaxClass',
        'discount' => 'getDiscount',
        'tax_category' => 'getTaxCategory',
        'sales_accounts' => 'getSalesAccounts',
        'item' => 'getItem'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sale_line_id', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('unit_quantity', $data ?? [], null);
        $this->setIfExists('unit_price', $data ?? [], null);
        $this->setIfExists('normal_unit_price', $data ?? [], null);
        $this->setIfExists('discount_amount', $data ?? [], null);
        $this->setIfExists('discount_percent', $data ?? [], null);
        $this->setIfExists('avg_cost', $data ?? [], null);
        $this->setIfExists('fifo_cost', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('tax1_rate', $data ?? [], null);
        $this->setIfExists('tax2_rate', $data ?? [], null);
        $this->setIfExists('is_layaway', $data ?? [], null);
        $this->setIfExists('is_workorder', $data ?? [], null);
        $this->setIfExists('is_special_order', $data ?? [], null);
        $this->setIfExists('displayable_subtotal', $data ?? [], null);
        $this->setIfExists('displayable_unit_price', $data ?? [], null);
        $this->setIfExists('calc_line_discount', $data ?? [], null);
        $this->setIfExists('calc_transaction_discount', $data ?? [], null);
        $this->setIfExists('calc_total', $data ?? [], null);
        $this->setIfExists('calc_subtotal', $data ?? [], null);
        $this->setIfExists('calc_tax1', $data ?? [], null);
        $this->setIfExists('calc_tax2', $data ?? [], null);
        $this->setIfExists('tax_class_id', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('discount_id', $data ?? [], null);
        $this->setIfExists('employee_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('note_id', $data ?? [], null);
        $this->setIfExists('parent_sale_line_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('tax_category_id', $data ?? [], null);
        $this->setIfExists('sale_id', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('tax_category', $data ?? [], null);
        $this->setIfExists('sales_accounts', $data ?? [], null);
        $this->setIfExists('item', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sale_line_id
     *
     * @return string|null
     */
    public function getSaleLineId()
    {
        return $this->container['sale_line_id'];
    }

    /**
     * Sets sale_line_id
     *
     * @param string|null $sale_line_id sale_line_id
     *
     * @return self
     */
    public function setSaleLineId($sale_line_id)
    {
        if (is_null($sale_line_id)) {
            throw new \InvalidArgumentException('non-nullable sale_line_id cannot be null');
        }
        $this->container['sale_line_id'] = $sale_line_id;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return string|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param string|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param string|null $time_stamp time_stamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets unit_quantity
     *
     * @return string|null
     */
    public function getUnitQuantity()
    {
        return $this->container['unit_quantity'];
    }

    /**
     * Sets unit_quantity
     *
     * @param string|null $unit_quantity unit_quantity
     *
     * @return self
     */
    public function setUnitQuantity($unit_quantity)
    {
        if (is_null($unit_quantity)) {
            throw new \InvalidArgumentException('non-nullable unit_quantity cannot be null');
        }
        $this->container['unit_quantity'] = $unit_quantity;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param string|null $unit_price unit_price
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        if (is_null($unit_price)) {
            throw new \InvalidArgumentException('non-nullable unit_price cannot be null');
        }
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets normal_unit_price
     *
     * @return string|null
     */
    public function getNormalUnitPrice()
    {
        return $this->container['normal_unit_price'];
    }

    /**
     * Sets normal_unit_price
     *
     * @param string|null $normal_unit_price normal_unit_price
     *
     * @return self
     */
    public function setNormalUnitPrice($normal_unit_price)
    {
        if (is_null($normal_unit_price)) {
            throw new \InvalidArgumentException('non-nullable normal_unit_price cannot be null');
        }
        $this->container['normal_unit_price'] = $normal_unit_price;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param string|null $discount_amount discount_amount
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        if (is_null($discount_amount)) {
            throw new \InvalidArgumentException('non-nullable discount_amount cannot be null');
        }
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_percent
     *
     * @return string|null
     */
    public function getDiscountPercent()
    {
        return $this->container['discount_percent'];
    }

    /**
     * Sets discount_percent
     *
     * @param string|null $discount_percent discount_percent
     *
     * @return self
     */
    public function setDiscountPercent($discount_percent)
    {
        if (is_null($discount_percent)) {
            throw new \InvalidArgumentException('non-nullable discount_percent cannot be null');
        }
        $this->container['discount_percent'] = $discount_percent;

        return $this;
    }

    /**
     * Gets avg_cost
     *
     * @return string|null
     */
    public function getAvgCost()
    {
        return $this->container['avg_cost'];
    }

    /**
     * Sets avg_cost
     *
     * @param string|null $avg_cost avg_cost
     *
     * @return self
     */
    public function setAvgCost($avg_cost)
    {
        if (is_null($avg_cost)) {
            throw new \InvalidArgumentException('non-nullable avg_cost cannot be null');
        }
        $this->container['avg_cost'] = $avg_cost;

        return $this;
    }

    /**
     * Gets fifo_cost
     *
     * @return string|null
     */
    public function getFifoCost()
    {
        return $this->container['fifo_cost'];
    }

    /**
     * Sets fifo_cost
     *
     * @param string|null $fifo_cost fifo_cost
     *
     * @return self
     */
    public function setFifoCost($fifo_cost)
    {
        if (is_null($fifo_cost)) {
            throw new \InvalidArgumentException('non-nullable fifo_cost cannot be null');
        }
        $this->container['fifo_cost'] = $fifo_cost;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return string|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param string|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax1_rate
     *
     * @return string|null
     */
    public function getTax1Rate()
    {
        return $this->container['tax1_rate'];
    }

    /**
     * Sets tax1_rate
     *
     * @param string|null $tax1_rate tax1_rate
     *
     * @return self
     */
    public function setTax1Rate($tax1_rate)
    {
        if (is_null($tax1_rate)) {
            throw new \InvalidArgumentException('non-nullable tax1_rate cannot be null');
        }
        $this->container['tax1_rate'] = $tax1_rate;

        return $this;
    }

    /**
     * Gets tax2_rate
     *
     * @return string|null
     */
    public function getTax2Rate()
    {
        return $this->container['tax2_rate'];
    }

    /**
     * Sets tax2_rate
     *
     * @param string|null $tax2_rate tax2_rate
     *
     * @return self
     */
    public function setTax2Rate($tax2_rate)
    {
        if (is_null($tax2_rate)) {
            throw new \InvalidArgumentException('non-nullable tax2_rate cannot be null');
        }
        $this->container['tax2_rate'] = $tax2_rate;

        return $this;
    }

    /**
     * Gets is_layaway
     *
     * @return string|null
     */
    public function getIsLayaway()
    {
        return $this->container['is_layaway'];
    }

    /**
     * Sets is_layaway
     *
     * @param string|null $is_layaway is_layaway
     *
     * @return self
     */
    public function setIsLayaway($is_layaway)
    {
        if (is_null($is_layaway)) {
            throw new \InvalidArgumentException('non-nullable is_layaway cannot be null');
        }
        $this->container['is_layaway'] = $is_layaway;

        return $this;
    }

    /**
     * Gets is_workorder
     *
     * @return string|null
     */
    public function getIsWorkorder()
    {
        return $this->container['is_workorder'];
    }

    /**
     * Sets is_workorder
     *
     * @param string|null $is_workorder is_workorder
     *
     * @return self
     */
    public function setIsWorkorder($is_workorder)
    {
        if (is_null($is_workorder)) {
            throw new \InvalidArgumentException('non-nullable is_workorder cannot be null');
        }
        $this->container['is_workorder'] = $is_workorder;

        return $this;
    }

    /**
     * Gets is_special_order
     *
     * @return string|null
     */
    public function getIsSpecialOrder()
    {
        return $this->container['is_special_order'];
    }

    /**
     * Sets is_special_order
     *
     * @param string|null $is_special_order is_special_order
     *
     * @return self
     */
    public function setIsSpecialOrder($is_special_order)
    {
        if (is_null($is_special_order)) {
            throw new \InvalidArgumentException('non-nullable is_special_order cannot be null');
        }
        $this->container['is_special_order'] = $is_special_order;

        return $this;
    }

    /**
     * Gets displayable_subtotal
     *
     * @return string|null
     */
    public function getDisplayableSubtotal()
    {
        return $this->container['displayable_subtotal'];
    }

    /**
     * Sets displayable_subtotal
     *
     * @param string|null $displayable_subtotal displayable_subtotal
     *
     * @return self
     */
    public function setDisplayableSubtotal($displayable_subtotal)
    {
        if (is_null($displayable_subtotal)) {
            throw new \InvalidArgumentException('non-nullable displayable_subtotal cannot be null');
        }
        $this->container['displayable_subtotal'] = $displayable_subtotal;

        return $this;
    }

    /**
     * Gets displayable_unit_price
     *
     * @return string|null
     */
    public function getDisplayableUnitPrice()
    {
        return $this->container['displayable_unit_price'];
    }

    /**
     * Sets displayable_unit_price
     *
     * @param string|null $displayable_unit_price displayable_unit_price
     *
     * @return self
     */
    public function setDisplayableUnitPrice($displayable_unit_price)
    {
        if (is_null($displayable_unit_price)) {
            throw new \InvalidArgumentException('non-nullable displayable_unit_price cannot be null');
        }
        $this->container['displayable_unit_price'] = $displayable_unit_price;

        return $this;
    }

    /**
     * Gets calc_line_discount
     *
     * @return string|null
     */
    public function getCalcLineDiscount()
    {
        return $this->container['calc_line_discount'];
    }

    /**
     * Sets calc_line_discount
     *
     * @param string|null $calc_line_discount calc_line_discount
     *
     * @return self
     */
    public function setCalcLineDiscount($calc_line_discount)
    {
        if (is_null($calc_line_discount)) {
            throw new \InvalidArgumentException('non-nullable calc_line_discount cannot be null');
        }
        $this->container['calc_line_discount'] = $calc_line_discount;

        return $this;
    }

    /**
     * Gets calc_transaction_discount
     *
     * @return string|null
     */
    public function getCalcTransactionDiscount()
    {
        return $this->container['calc_transaction_discount'];
    }

    /**
     * Sets calc_transaction_discount
     *
     * @param string|null $calc_transaction_discount calc_transaction_discount
     *
     * @return self
     */
    public function setCalcTransactionDiscount($calc_transaction_discount)
    {
        if (is_null($calc_transaction_discount)) {
            throw new \InvalidArgumentException('non-nullable calc_transaction_discount cannot be null');
        }
        $this->container['calc_transaction_discount'] = $calc_transaction_discount;

        return $this;
    }

    /**
     * Gets calc_total
     *
     * @return string|null
     */
    public function getCalcTotal()
    {
        return $this->container['calc_total'];
    }

    /**
     * Sets calc_total
     *
     * @param string|null $calc_total calc_total
     *
     * @return self
     */
    public function setCalcTotal($calc_total)
    {
        if (is_null($calc_total)) {
            throw new \InvalidArgumentException('non-nullable calc_total cannot be null');
        }
        $this->container['calc_total'] = $calc_total;

        return $this;
    }

    /**
     * Gets calc_subtotal
     *
     * @return string|null
     */
    public function getCalcSubtotal()
    {
        return $this->container['calc_subtotal'];
    }

    /**
     * Sets calc_subtotal
     *
     * @param string|null $calc_subtotal calc_subtotal
     *
     * @return self
     */
    public function setCalcSubtotal($calc_subtotal)
    {
        if (is_null($calc_subtotal)) {
            throw new \InvalidArgumentException('non-nullable calc_subtotal cannot be null');
        }
        $this->container['calc_subtotal'] = $calc_subtotal;

        return $this;
    }

    /**
     * Gets calc_tax1
     *
     * @return string|null
     */
    public function getCalcTax1()
    {
        return $this->container['calc_tax1'];
    }

    /**
     * Sets calc_tax1
     *
     * @param string|null $calc_tax1 calc_tax1
     *
     * @return self
     */
    public function setCalcTax1($calc_tax1)
    {
        if (is_null($calc_tax1)) {
            throw new \InvalidArgumentException('non-nullable calc_tax1 cannot be null');
        }
        $this->container['calc_tax1'] = $calc_tax1;

        return $this;
    }

    /**
     * Gets calc_tax2
     *
     * @return string|null
     */
    public function getCalcTax2()
    {
        return $this->container['calc_tax2'];
    }

    /**
     * Sets calc_tax2
     *
     * @param string|null $calc_tax2 calc_tax2
     *
     * @return self
     */
    public function setCalcTax2($calc_tax2)
    {
        if (is_null($calc_tax2)) {
            throw new \InvalidArgumentException('non-nullable calc_tax2 cannot be null');
        }
        $this->container['calc_tax2'] = $calc_tax2;

        return $this;
    }

    /**
     * Gets tax_class_id
     *
     * @return string|null
     */
    public function getTaxClassId()
    {
        return $this->container['tax_class_id'];
    }

    /**
     * Sets tax_class_id
     *
     * @param string|null $tax_class_id tax_class_id
     *
     * @return self
     */
    public function setTaxClassId($tax_class_id)
    {
        if (is_null($tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable tax_class_id cannot be null');
        }
        $this->container['tax_class_id'] = $tax_class_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets discount_id
     *
     * @return string|null
     */
    public function getDiscountId()
    {
        return $this->container['discount_id'];
    }

    /**
     * Sets discount_id
     *
     * @param string|null $discount_id discount_id
     *
     * @return self
     */
    public function setDiscountId($discount_id)
    {
        if (is_null($discount_id)) {
            throw new \InvalidArgumentException('non-nullable discount_id cannot be null');
        }
        $this->container['discount_id'] = $discount_id;

        return $this;
    }

    /**
     * Gets employee_id
     *
     * @return string|null
     */
    public function getEmployeeId()
    {
        return $this->container['employee_id'];
    }

    /**
     * Sets employee_id
     *
     * @param string|null $employee_id employee_id
     *
     * @return self
     */
    public function setEmployeeId($employee_id)
    {
        if (is_null($employee_id)) {
            throw new \InvalidArgumentException('non-nullable employee_id cannot be null');
        }
        $this->container['employee_id'] = $employee_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return string|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param string|null $item_id item_id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets note_id
     *
     * @return string|null
     */
    public function getNoteId()
    {
        return $this->container['note_id'];
    }

    /**
     * Sets note_id
     *
     * @param string|null $note_id note_id
     *
     * @return self
     */
    public function setNoteId($note_id)
    {
        if (is_null($note_id)) {
            throw new \InvalidArgumentException('non-nullable note_id cannot be null');
        }
        $this->container['note_id'] = $note_id;

        return $this;
    }

    /**
     * Gets parent_sale_line_id
     *
     * @return string|null
     */
    public function getParentSaleLineId()
    {
        return $this->container['parent_sale_line_id'];
    }

    /**
     * Sets parent_sale_line_id
     *
     * @param string|null $parent_sale_line_id parent_sale_line_id
     *
     * @return self
     */
    public function setParentSaleLineId($parent_sale_line_id)
    {
        if (is_null($parent_sale_line_id)) {
            throw new \InvalidArgumentException('non-nullable parent_sale_line_id cannot be null');
        }
        $this->container['parent_sale_line_id'] = $parent_sale_line_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return string|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param string|null $shop_id shop_id
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets tax_category_id
     *
     * @return string|null
     */
    public function getTaxCategoryId()
    {
        return $this->container['tax_category_id'];
    }

    /**
     * Sets tax_category_id
     *
     * @param string|null $tax_category_id tax_category_id
     *
     * @return self
     */
    public function setTaxCategoryId($tax_category_id)
    {
        if (is_null($tax_category_id)) {
            throw new \InvalidArgumentException('non-nullable tax_category_id cannot be null');
        }
        $this->container['tax_category_id'] = $tax_category_id;

        return $this;
    }

    /**
     * Gets sale_id
     *
     * @return string|null
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param string|null $sale_id sale_id
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return \LightspeedV3\Model\TaxClass|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param \LightspeedV3\Model\TaxClass|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return \LightspeedV3\Model\Discount|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param \LightspeedV3\Model\Discount|null $discount discount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets tax_category
     *
     * @return \LightspeedV3\Model\TaxCategory|null
     */
    public function getTaxCategory()
    {
        return $this->container['tax_category'];
    }

    /**
     * Sets tax_category
     *
     * @param \LightspeedV3\Model\TaxCategory|null $tax_category tax_category
     *
     * @return self
     */
    public function setTaxCategory($tax_category)
    {
        if (is_null($tax_category)) {
            throw new \InvalidArgumentException('non-nullable tax_category cannot be null');
        }
        $this->container['tax_category'] = $tax_category;

        return $this;
    }

    /**
     * Gets sales_accounts
     *
     * @return \LightspeedV3\Model\SaleLineSalesAccounts|null
     */
    public function getSalesAccounts()
    {
        return $this->container['sales_accounts'];
    }

    /**
     * Sets sales_accounts
     *
     * @param \LightspeedV3\Model\SaleLineSalesAccounts|null $sales_accounts sales_accounts
     *
     * @return self
     */
    public function setSalesAccounts($sales_accounts)
    {
        if (is_null($sales_accounts)) {
            throw new \InvalidArgumentException('non-nullable sales_accounts cannot be null');
        }
        $this->container['sales_accounts'] = $sales_accounts;

        return $this;
    }

    /**
     * Gets item
     *
     * @return \LightspeedV3\Model\Item|null
     */
    public function getItem()
    {
        return $this->container['item'];
    }

    /**
     * Sets item
     *
     * @param \LightspeedV3\Model\Item|null $item item
     *
     * @return self
     */
    public function setItem($item)
    {
        if (is_null($item)) {
            throw new \InvalidArgumentException('non-nullable item cannot be null');
        }
        $this->container['item'] = $item;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


