<?php
/**
 * Sale
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Sale Class Doc Comment
 *
 * @category Class
 * @description Sale transaction information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Sale implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Sale';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sale_id' => 'int',
        'time_stamp' => '\DateTime',
        'discount_percent' => 'float',
        'completed' => 'bool',
        'archived' => 'bool',
        'voided' => 'bool',
        'enable_promotions' => 'bool',
        'is_tax_inclusive' => 'bool',
        'create_time' => '\DateTime',
        'update_time' => '\DateTime',
        'complete_time' => '\DateTime',
        'reference_number' => 'string',
        'reference_number_source' => 'string',
        'tax1_rate' => 'float',
        'tax2_rate' => 'float',
        'change' => 'float',
        'receipt_preference' => 'string',
        'displayable_subtotal' => 'float',
        'ticket_number' => 'string',
        'calc_discount' => 'float',
        'total' => 'float',
        'calc_total' => 'float',
        'calc_subtotal' => 'float',
        'calc_taxable' => 'float',
        'calc_non_taxable' => 'float',
        'calc_avg_cost' => 'float',
        'calc_fifo_cost' => 'float',
        'calc_tax1' => 'float',
        'calc_tax2' => 'float',
        'calc_payments' => 'float',
        'calc_item_fees' => 'float',
        'total_due' => 'float',
        'displayable_total' => 'float',
        'balance' => 'float',
        'customer_id' => 'int',
        'discount_id' => 'int',
        'employee_id' => 'int',
        'quote_id' => 'int',
        'register_id' => 'int',
        'ship_to_id' => 'int',
        'shop_id' => 'int',
        'tax_category_id' => 'int',
        'tippable_amount' => 'float',
        'tax_total' => 'float',
        'sale_lines' => '\LightspeedV3\Model\SaleLinesWrapper',
        'sale_payments' => '\LightspeedV3\Model\SalePaymentsWrapper',
        'sale_notes' => '\LightspeedV3\Model\SaleNotesWrapper',
        'customer' => '\LightspeedV3\Model\Customer',
        'shop' => '\LightspeedV3\Model\Shop',
        'tax_category' => '\LightspeedV3\Model\TaxCategory',
        'tax_class_totals' => '\LightspeedV3\Model\TaxClassTotals',
        'discount' => '\LightspeedV3\Model\Discount',
        'quote' => '\LightspeedV3\Model\Quote',
        'ship_to' => '\LightspeedV3\Model\ShipTo'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sale_id' => null,
        'time_stamp' => 'date-time',
        'discount_percent' => 'float',
        'completed' => null,
        'archived' => null,
        'voided' => null,
        'enable_promotions' => null,
        'is_tax_inclusive' => null,
        'create_time' => 'date-time',
        'update_time' => 'date-time',
        'complete_time' => 'date-time',
        'reference_number' => null,
        'reference_number_source' => null,
        'tax1_rate' => 'float',
        'tax2_rate' => 'float',
        'change' => 'float',
        'receipt_preference' => null,
        'displayable_subtotal' => 'float',
        'ticket_number' => null,
        'calc_discount' => 'float',
        'total' => 'float',
        'calc_total' => 'float',
        'calc_subtotal' => 'float',
        'calc_taxable' => 'float',
        'calc_non_taxable' => 'float',
        'calc_avg_cost' => 'float',
        'calc_fifo_cost' => 'float',
        'calc_tax1' => 'float',
        'calc_tax2' => 'float',
        'calc_payments' => 'float',
        'calc_item_fees' => 'float',
        'total_due' => 'float',
        'displayable_total' => 'float',
        'balance' => 'float',
        'customer_id' => null,
        'discount_id' => null,
        'employee_id' => null,
        'quote_id' => null,
        'register_id' => null,
        'ship_to_id' => null,
        'shop_id' => null,
        'tax_category_id' => null,
        'tippable_amount' => 'float',
        'tax_total' => 'float',
        'sale_lines' => null,
        'sale_payments' => null,
        'sale_notes' => null,
        'customer' => null,
        'shop' => null,
        'tax_category' => null,
        'tax_class_totals' => null,
        'discount' => null,
        'quote' => null,
        'ship_to' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sale_id' => false,
        'time_stamp' => false,
        'discount_percent' => false,
        'completed' => false,
        'archived' => false,
        'voided' => false,
        'enable_promotions' => false,
        'is_tax_inclusive' => false,
        'create_time' => false,
        'update_time' => false,
        'complete_time' => false,
        'reference_number' => false,
        'reference_number_source' => false,
        'tax1_rate' => false,
        'tax2_rate' => false,
        'change' => false,
        'receipt_preference' => false,
        'displayable_subtotal' => false,
        'ticket_number' => false,
        'calc_discount' => false,
        'total' => false,
        'calc_total' => false,
        'calc_subtotal' => false,
        'calc_taxable' => false,
        'calc_non_taxable' => false,
        'calc_avg_cost' => false,
        'calc_fifo_cost' => false,
        'calc_tax1' => false,
        'calc_tax2' => false,
        'calc_payments' => false,
        'calc_item_fees' => false,
        'total_due' => false,
        'displayable_total' => false,
        'balance' => false,
        'customer_id' => false,
        'discount_id' => false,
        'employee_id' => false,
        'quote_id' => false,
        'register_id' => false,
        'ship_to_id' => false,
        'shop_id' => false,
        'tax_category_id' => false,
        'tippable_amount' => false,
        'tax_total' => false,
        'sale_lines' => false,
        'sale_payments' => false,
        'sale_notes' => false,
        'customer' => false,
        'shop' => false,
        'tax_category' => false,
        'tax_class_totals' => false,
        'discount' => false,
        'quote' => false,
        'ship_to' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sale_id' => 'saleID',
        'time_stamp' => 'timeStamp',
        'discount_percent' => 'discountPercent',
        'completed' => 'completed',
        'archived' => 'archived',
        'voided' => 'voided',
        'enable_promotions' => 'enablePromotions',
        'is_tax_inclusive' => 'isTaxInclusive',
        'create_time' => 'createTime',
        'update_time' => 'updateTime',
        'complete_time' => 'completeTime',
        'reference_number' => 'referenceNumber',
        'reference_number_source' => 'referenceNumberSource',
        'tax1_rate' => 'tax1Rate',
        'tax2_rate' => 'tax2Rate',
        'change' => 'change',
        'receipt_preference' => 'receiptPreference',
        'displayable_subtotal' => 'displayableSubtotal',
        'ticket_number' => 'ticketNumber',
        'calc_discount' => 'calcDiscount',
        'total' => 'total',
        'calc_total' => 'calcTotal',
        'calc_subtotal' => 'calcSubtotal',
        'calc_taxable' => 'calcTaxable',
        'calc_non_taxable' => 'calcNonTaxable',
        'calc_avg_cost' => 'calcAvgCost',
        'calc_fifo_cost' => 'calcFIFOCost',
        'calc_tax1' => 'calcTax1',
        'calc_tax2' => 'calcTax2',
        'calc_payments' => 'calcPayments',
        'calc_item_fees' => 'calcItemFees',
        'total_due' => 'totalDue',
        'displayable_total' => 'displayableTotal',
        'balance' => 'balance',
        'customer_id' => 'customerID',
        'discount_id' => 'discountID',
        'employee_id' => 'employeeID',
        'quote_id' => 'quoteID',
        'register_id' => 'registerID',
        'ship_to_id' => 'shipToID',
        'shop_id' => 'shopID',
        'tax_category_id' => 'taxCategoryID',
        'tippable_amount' => 'tippableAmount',
        'tax_total' => 'taxTotal',
        'sale_lines' => 'SaleLines',
        'sale_payments' => 'SalePayments',
        'sale_notes' => 'SaleNotes',
        'customer' => 'Customer',
        'shop' => 'Shop',
        'tax_category' => 'TaxCategory',
        'tax_class_totals' => 'TaxClassTotals',
        'discount' => 'Discount',
        'quote' => 'Quote',
        'ship_to' => 'ShipTo'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sale_id' => 'setSaleId',
        'time_stamp' => 'setTimeStamp',
        'discount_percent' => 'setDiscountPercent',
        'completed' => 'setCompleted',
        'archived' => 'setArchived',
        'voided' => 'setVoided',
        'enable_promotions' => 'setEnablePromotions',
        'is_tax_inclusive' => 'setIsTaxInclusive',
        'create_time' => 'setCreateTime',
        'update_time' => 'setUpdateTime',
        'complete_time' => 'setCompleteTime',
        'reference_number' => 'setReferenceNumber',
        'reference_number_source' => 'setReferenceNumberSource',
        'tax1_rate' => 'setTax1Rate',
        'tax2_rate' => 'setTax2Rate',
        'change' => 'setChange',
        'receipt_preference' => 'setReceiptPreference',
        'displayable_subtotal' => 'setDisplayableSubtotal',
        'ticket_number' => 'setTicketNumber',
        'calc_discount' => 'setCalcDiscount',
        'total' => 'setTotal',
        'calc_total' => 'setCalcTotal',
        'calc_subtotal' => 'setCalcSubtotal',
        'calc_taxable' => 'setCalcTaxable',
        'calc_non_taxable' => 'setCalcNonTaxable',
        'calc_avg_cost' => 'setCalcAvgCost',
        'calc_fifo_cost' => 'setCalcFifoCost',
        'calc_tax1' => 'setCalcTax1',
        'calc_tax2' => 'setCalcTax2',
        'calc_payments' => 'setCalcPayments',
        'calc_item_fees' => 'setCalcItemFees',
        'total_due' => 'setTotalDue',
        'displayable_total' => 'setDisplayableTotal',
        'balance' => 'setBalance',
        'customer_id' => 'setCustomerId',
        'discount_id' => 'setDiscountId',
        'employee_id' => 'setEmployeeId',
        'quote_id' => 'setQuoteId',
        'register_id' => 'setRegisterId',
        'ship_to_id' => 'setShipToId',
        'shop_id' => 'setShopId',
        'tax_category_id' => 'setTaxCategoryId',
        'tippable_amount' => 'setTippableAmount',
        'tax_total' => 'setTaxTotal',
        'sale_lines' => 'setSaleLines',
        'sale_payments' => 'setSalePayments',
        'sale_notes' => 'setSaleNotes',
        'customer' => 'setCustomer',
        'shop' => 'setShop',
        'tax_category' => 'setTaxCategory',
        'tax_class_totals' => 'setTaxClassTotals',
        'discount' => 'setDiscount',
        'quote' => 'setQuote',
        'ship_to' => 'setShipTo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sale_id' => 'getSaleId',
        'time_stamp' => 'getTimeStamp',
        'discount_percent' => 'getDiscountPercent',
        'completed' => 'getCompleted',
        'archived' => 'getArchived',
        'voided' => 'getVoided',
        'enable_promotions' => 'getEnablePromotions',
        'is_tax_inclusive' => 'getIsTaxInclusive',
        'create_time' => 'getCreateTime',
        'update_time' => 'getUpdateTime',
        'complete_time' => 'getCompleteTime',
        'reference_number' => 'getReferenceNumber',
        'reference_number_source' => 'getReferenceNumberSource',
        'tax1_rate' => 'getTax1Rate',
        'tax2_rate' => 'getTax2Rate',
        'change' => 'getChange',
        'receipt_preference' => 'getReceiptPreference',
        'displayable_subtotal' => 'getDisplayableSubtotal',
        'ticket_number' => 'getTicketNumber',
        'calc_discount' => 'getCalcDiscount',
        'total' => 'getTotal',
        'calc_total' => 'getCalcTotal',
        'calc_subtotal' => 'getCalcSubtotal',
        'calc_taxable' => 'getCalcTaxable',
        'calc_non_taxable' => 'getCalcNonTaxable',
        'calc_avg_cost' => 'getCalcAvgCost',
        'calc_fifo_cost' => 'getCalcFifoCost',
        'calc_tax1' => 'getCalcTax1',
        'calc_tax2' => 'getCalcTax2',
        'calc_payments' => 'getCalcPayments',
        'calc_item_fees' => 'getCalcItemFees',
        'total_due' => 'getTotalDue',
        'displayable_total' => 'getDisplayableTotal',
        'balance' => 'getBalance',
        'customer_id' => 'getCustomerId',
        'discount_id' => 'getDiscountId',
        'employee_id' => 'getEmployeeId',
        'quote_id' => 'getQuoteId',
        'register_id' => 'getRegisterId',
        'ship_to_id' => 'getShipToId',
        'shop_id' => 'getShopId',
        'tax_category_id' => 'getTaxCategoryId',
        'tippable_amount' => 'getTippableAmount',
        'tax_total' => 'getTaxTotal',
        'sale_lines' => 'getSaleLines',
        'sale_payments' => 'getSalePayments',
        'sale_notes' => 'getSaleNotes',
        'customer' => 'getCustomer',
        'shop' => 'getShop',
        'tax_category' => 'getTaxCategory',
        'tax_class_totals' => 'getTaxClassTotals',
        'discount' => 'getDiscount',
        'quote' => 'getQuote',
        'ship_to' => 'getShipTo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sale_id', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('discount_percent', $data ?? [], null);
        $this->setIfExists('completed', $data ?? [], false);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('voided', $data ?? [], false);
        $this->setIfExists('enable_promotions', $data ?? [], true);
        $this->setIfExists('is_tax_inclusive', $data ?? [], false);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('update_time', $data ?? [], null);
        $this->setIfExists('complete_time', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('reference_number_source', $data ?? [], null);
        $this->setIfExists('tax1_rate', $data ?? [], null);
        $this->setIfExists('tax2_rate', $data ?? [], null);
        $this->setIfExists('change', $data ?? [], null);
        $this->setIfExists('receipt_preference', $data ?? [], null);
        $this->setIfExists('displayable_subtotal', $data ?? [], null);
        $this->setIfExists('ticket_number', $data ?? [], null);
        $this->setIfExists('calc_discount', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('calc_total', $data ?? [], null);
        $this->setIfExists('calc_subtotal', $data ?? [], null);
        $this->setIfExists('calc_taxable', $data ?? [], null);
        $this->setIfExists('calc_non_taxable', $data ?? [], null);
        $this->setIfExists('calc_avg_cost', $data ?? [], null);
        $this->setIfExists('calc_fifo_cost', $data ?? [], null);
        $this->setIfExists('calc_tax1', $data ?? [], null);
        $this->setIfExists('calc_tax2', $data ?? [], null);
        $this->setIfExists('calc_payments', $data ?? [], null);
        $this->setIfExists('calc_item_fees', $data ?? [], null);
        $this->setIfExists('total_due', $data ?? [], null);
        $this->setIfExists('displayable_total', $data ?? [], null);
        $this->setIfExists('balance', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('discount_id', $data ?? [], null);
        $this->setIfExists('employee_id', $data ?? [], null);
        $this->setIfExists('quote_id', $data ?? [], null);
        $this->setIfExists('register_id', $data ?? [], null);
        $this->setIfExists('ship_to_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('tax_category_id', $data ?? [], null);
        $this->setIfExists('tippable_amount', $data ?? [], null);
        $this->setIfExists('tax_total', $data ?? [], null);
        $this->setIfExists('sale_lines', $data ?? [], null);
        $this->setIfExists('sale_payments', $data ?? [], null);
        $this->setIfExists('sale_notes', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('shop', $data ?? [], null);
        $this->setIfExists('tax_category', $data ?? [], null);
        $this->setIfExists('tax_class_totals', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('quote', $data ?? [], null);
        $this->setIfExists('ship_to', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sale_id'] === null) {
            $invalidProperties[] = "'sale_id' can't be null";
        }
        if ($this->container['total'] === null) {
            $invalidProperties[] = "'total' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sale_id
     *
     * @return int
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param int $sale_id Unique sale identifier
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return \DateTime|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param \DateTime|null $time_stamp Sale timestamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets discount_percent
     *
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->container['discount_percent'];
    }

    /**
     * Sets discount_percent
     *
     * @param float|null $discount_percent Discount percentage applied
     *
     * @return self
     */
    public function setDiscountPercent($discount_percent)
    {
        if (is_null($discount_percent)) {
            throw new \InvalidArgumentException('non-nullable discount_percent cannot be null');
        }
        $this->container['discount_percent'] = $discount_percent;

        return $this;
    }

    /**
     * Gets completed
     *
     * @return bool|null
     */
    public function getCompleted()
    {
        return $this->container['completed'];
    }

    /**
     * Sets completed
     *
     * @param bool|null $completed Whether sale is completed
     *
     * @return self
     */
    public function setCompleted($completed)
    {
        if (is_null($completed)) {
            throw new \InvalidArgumentException('non-nullable completed cannot be null');
        }
        $this->container['completed'] = $completed;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Whether sale is archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets voided
     *
     * @return bool|null
     */
    public function getVoided()
    {
        return $this->container['voided'];
    }

    /**
     * Sets voided
     *
     * @param bool|null $voided Whether sale is voided
     *
     * @return self
     */
    public function setVoided($voided)
    {
        if (is_null($voided)) {
            throw new \InvalidArgumentException('non-nullable voided cannot be null');
        }
        $this->container['voided'] = $voided;

        return $this;
    }

    /**
     * Gets enable_promotions
     *
     * @return bool|null
     */
    public function getEnablePromotions()
    {
        return $this->container['enable_promotions'];
    }

    /**
     * Sets enable_promotions
     *
     * @param bool|null $enable_promotions Whether promotions are enabled
     *
     * @return self
     */
    public function setEnablePromotions($enable_promotions)
    {
        if (is_null($enable_promotions)) {
            throw new \InvalidArgumentException('non-nullable enable_promotions cannot be null');
        }
        $this->container['enable_promotions'] = $enable_promotions;

        return $this;
    }

    /**
     * Gets is_tax_inclusive
     *
     * @return bool|null
     */
    public function getIsTaxInclusive()
    {
        return $this->container['is_tax_inclusive'];
    }

    /**
     * Sets is_tax_inclusive
     *
     * @param bool|null $is_tax_inclusive Whether tax is inclusive
     *
     * @return self
     */
    public function setIsTaxInclusive($is_tax_inclusive)
    {
        if (is_null($is_tax_inclusive)) {
            throw new \InvalidArgumentException('non-nullable is_tax_inclusive cannot be null');
        }
        $this->container['is_tax_inclusive'] = $is_tax_inclusive;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return \DateTime|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param \DateTime|null $create_time Sale creation time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets update_time
     *
     * @return \DateTime|null
     */
    public function getUpdateTime()
    {
        return $this->container['update_time'];
    }

    /**
     * Sets update_time
     *
     * @param \DateTime|null $update_time Sale last update time
     *
     * @return self
     */
    public function setUpdateTime($update_time)
    {
        if (is_null($update_time)) {
            throw new \InvalidArgumentException('non-nullable update_time cannot be null');
        }
        $this->container['update_time'] = $update_time;

        return $this;
    }

    /**
     * Gets complete_time
     *
     * @return \DateTime|null
     */
    public function getCompleteTime()
    {
        return $this->container['complete_time'];
    }

    /**
     * Sets complete_time
     *
     * @param \DateTime|null $complete_time Sale completion time
     *
     * @return self
     */
    public function setCompleteTime($complete_time)
    {
        if (is_null($complete_time)) {
            throw new \InvalidArgumentException('non-nullable complete_time cannot be null');
        }
        $this->container['complete_time'] = $complete_time;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number Reference number for the sale
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            throw new \InvalidArgumentException('non-nullable reference_number cannot be null');
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets reference_number_source
     *
     * @return string|null
     */
    public function getReferenceNumberSource()
    {
        return $this->container['reference_number_source'];
    }

    /**
     * Sets reference_number_source
     *
     * @param string|null $reference_number_source Source of reference number
     *
     * @return self
     */
    public function setReferenceNumberSource($reference_number_source)
    {
        if (is_null($reference_number_source)) {
            throw new \InvalidArgumentException('non-nullable reference_number_source cannot be null');
        }
        $this->container['reference_number_source'] = $reference_number_source;

        return $this;
    }

    /**
     * Gets tax1_rate
     *
     * @return float|null
     */
    public function getTax1Rate()
    {
        return $this->container['tax1_rate'];
    }

    /**
     * Sets tax1_rate
     *
     * @param float|null $tax1_rate Tax 1 rate
     *
     * @return self
     */
    public function setTax1Rate($tax1_rate)
    {
        if (is_null($tax1_rate)) {
            throw new \InvalidArgumentException('non-nullable tax1_rate cannot be null');
        }
        $this->container['tax1_rate'] = $tax1_rate;

        return $this;
    }

    /**
     * Gets tax2_rate
     *
     * @return float|null
     */
    public function getTax2Rate()
    {
        return $this->container['tax2_rate'];
    }

    /**
     * Sets tax2_rate
     *
     * @param float|null $tax2_rate Tax 2 rate
     *
     * @return self
     */
    public function setTax2Rate($tax2_rate)
    {
        if (is_null($tax2_rate)) {
            throw new \InvalidArgumentException('non-nullable tax2_rate cannot be null');
        }
        $this->container['tax2_rate'] = $tax2_rate;

        return $this;
    }

    /**
     * Gets change
     *
     * @return float|null
     */
    public function getChange()
    {
        return $this->container['change'];
    }

    /**
     * Sets change
     *
     * @param float|null $change Change given
     *
     * @return self
     */
    public function setChange($change)
    {
        if (is_null($change)) {
            throw new \InvalidArgumentException('non-nullable change cannot be null');
        }
        $this->container['change'] = $change;

        return $this;
    }

    /**
     * Gets receipt_preference
     *
     * @return string|null
     */
    public function getReceiptPreference()
    {
        return $this->container['receipt_preference'];
    }

    /**
     * Sets receipt_preference
     *
     * @param string|null $receipt_preference Receipt preference (printed, email, etc)
     *
     * @return self
     */
    public function setReceiptPreference($receipt_preference)
    {
        if (is_null($receipt_preference)) {
            throw new \InvalidArgumentException('non-nullable receipt_preference cannot be null');
        }
        $this->container['receipt_preference'] = $receipt_preference;

        return $this;
    }

    /**
     * Gets displayable_subtotal
     *
     * @return float|null
     */
    public function getDisplayableSubtotal()
    {
        return $this->container['displayable_subtotal'];
    }

    /**
     * Sets displayable_subtotal
     *
     * @param float|null $displayable_subtotal Displayable subtotal amount
     *
     * @return self
     */
    public function setDisplayableSubtotal($displayable_subtotal)
    {
        if (is_null($displayable_subtotal)) {
            throw new \InvalidArgumentException('non-nullable displayable_subtotal cannot be null');
        }
        $this->container['displayable_subtotal'] = $displayable_subtotal;

        return $this;
    }

    /**
     * Gets ticket_number
     *
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->container['ticket_number'];
    }

    /**
     * Sets ticket_number
     *
     * @param string|null $ticket_number Ticket number for the sale
     *
     * @return self
     */
    public function setTicketNumber($ticket_number)
    {
        if (is_null($ticket_number)) {
            throw new \InvalidArgumentException('non-nullable ticket_number cannot be null');
        }
        $this->container['ticket_number'] = $ticket_number;

        return $this;
    }

    /**
     * Gets calc_discount
     *
     * @return float|null
     */
    public function getCalcDiscount()
    {
        return $this->container['calc_discount'];
    }

    /**
     * Sets calc_discount
     *
     * @param float|null $calc_discount Calculated discount amount
     *
     * @return self
     */
    public function setCalcDiscount($calc_discount)
    {
        if (is_null($calc_discount)) {
            throw new \InvalidArgumentException('non-nullable calc_discount cannot be null');
        }
        $this->container['calc_discount'] = $calc_discount;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float $total Total sale amount
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets calc_total
     *
     * @return float|null
     */
    public function getCalcTotal()
    {
        return $this->container['calc_total'];
    }

    /**
     * Sets calc_total
     *
     * @param float|null $calc_total Calculated total amount
     *
     * @return self
     */
    public function setCalcTotal($calc_total)
    {
        if (is_null($calc_total)) {
            throw new \InvalidArgumentException('non-nullable calc_total cannot be null');
        }
        $this->container['calc_total'] = $calc_total;

        return $this;
    }

    /**
     * Gets calc_subtotal
     *
     * @return float|null
     */
    public function getCalcSubtotal()
    {
        return $this->container['calc_subtotal'];
    }

    /**
     * Sets calc_subtotal
     *
     * @param float|null $calc_subtotal Calculated subtotal amount
     *
     * @return self
     */
    public function setCalcSubtotal($calc_subtotal)
    {
        if (is_null($calc_subtotal)) {
            throw new \InvalidArgumentException('non-nullable calc_subtotal cannot be null');
        }
        $this->container['calc_subtotal'] = $calc_subtotal;

        return $this;
    }

    /**
     * Gets calc_taxable
     *
     * @return float|null
     */
    public function getCalcTaxable()
    {
        return $this->container['calc_taxable'];
    }

    /**
     * Sets calc_taxable
     *
     * @param float|null $calc_taxable Calculated taxable amount
     *
     * @return self
     */
    public function setCalcTaxable($calc_taxable)
    {
        if (is_null($calc_taxable)) {
            throw new \InvalidArgumentException('non-nullable calc_taxable cannot be null');
        }
        $this->container['calc_taxable'] = $calc_taxable;

        return $this;
    }

    /**
     * Gets calc_non_taxable
     *
     * @return float|null
     */
    public function getCalcNonTaxable()
    {
        return $this->container['calc_non_taxable'];
    }

    /**
     * Sets calc_non_taxable
     *
     * @param float|null $calc_non_taxable Calculated non-taxable amount
     *
     * @return self
     */
    public function setCalcNonTaxable($calc_non_taxable)
    {
        if (is_null($calc_non_taxable)) {
            throw new \InvalidArgumentException('non-nullable calc_non_taxable cannot be null');
        }
        $this->container['calc_non_taxable'] = $calc_non_taxable;

        return $this;
    }

    /**
     * Gets calc_avg_cost
     *
     * @return float|null
     */
    public function getCalcAvgCost()
    {
        return $this->container['calc_avg_cost'];
    }

    /**
     * Sets calc_avg_cost
     *
     * @param float|null $calc_avg_cost Calculated average cost
     *
     * @return self
     */
    public function setCalcAvgCost($calc_avg_cost)
    {
        if (is_null($calc_avg_cost)) {
            throw new \InvalidArgumentException('non-nullable calc_avg_cost cannot be null');
        }
        $this->container['calc_avg_cost'] = $calc_avg_cost;

        return $this;
    }

    /**
     * Gets calc_fifo_cost
     *
     * @return float|null
     */
    public function getCalcFifoCost()
    {
        return $this->container['calc_fifo_cost'];
    }

    /**
     * Sets calc_fifo_cost
     *
     * @param float|null $calc_fifo_cost Calculated FIFO cost
     *
     * @return self
     */
    public function setCalcFifoCost($calc_fifo_cost)
    {
        if (is_null($calc_fifo_cost)) {
            throw new \InvalidArgumentException('non-nullable calc_fifo_cost cannot be null');
        }
        $this->container['calc_fifo_cost'] = $calc_fifo_cost;

        return $this;
    }

    /**
     * Gets calc_tax1
     *
     * @return float|null
     */
    public function getCalcTax1()
    {
        return $this->container['calc_tax1'];
    }

    /**
     * Sets calc_tax1
     *
     * @param float|null $calc_tax1 Calculated tax 1 amount
     *
     * @return self
     */
    public function setCalcTax1($calc_tax1)
    {
        if (is_null($calc_tax1)) {
            throw new \InvalidArgumentException('non-nullable calc_tax1 cannot be null');
        }
        $this->container['calc_tax1'] = $calc_tax1;

        return $this;
    }

    /**
     * Gets calc_tax2
     *
     * @return float|null
     */
    public function getCalcTax2()
    {
        return $this->container['calc_tax2'];
    }

    /**
     * Sets calc_tax2
     *
     * @param float|null $calc_tax2 Calculated tax 2 amount
     *
     * @return self
     */
    public function setCalcTax2($calc_tax2)
    {
        if (is_null($calc_tax2)) {
            throw new \InvalidArgumentException('non-nullable calc_tax2 cannot be null');
        }
        $this->container['calc_tax2'] = $calc_tax2;

        return $this;
    }

    /**
     * Gets calc_payments
     *
     * @return float|null
     */
    public function getCalcPayments()
    {
        return $this->container['calc_payments'];
    }

    /**
     * Sets calc_payments
     *
     * @param float|null $calc_payments Calculated payments amount
     *
     * @return self
     */
    public function setCalcPayments($calc_payments)
    {
        if (is_null($calc_payments)) {
            throw new \InvalidArgumentException('non-nullable calc_payments cannot be null');
        }
        $this->container['calc_payments'] = $calc_payments;

        return $this;
    }

    /**
     * Gets calc_item_fees
     *
     * @return float|null
     */
    public function getCalcItemFees()
    {
        return $this->container['calc_item_fees'];
    }

    /**
     * Sets calc_item_fees
     *
     * @param float|null $calc_item_fees Calculated item fees
     *
     * @return self
     */
    public function setCalcItemFees($calc_item_fees)
    {
        if (is_null($calc_item_fees)) {
            throw new \InvalidArgumentException('non-nullable calc_item_fees cannot be null');
        }
        $this->container['calc_item_fees'] = $calc_item_fees;

        return $this;
    }

    /**
     * Gets total_due
     *
     * @return float|null
     */
    public function getTotalDue()
    {
        return $this->container['total_due'];
    }

    /**
     * Sets total_due
     *
     * @param float|null $total_due Total amount due
     *
     * @return self
     */
    public function setTotalDue($total_due)
    {
        if (is_null($total_due)) {
            throw new \InvalidArgumentException('non-nullable total_due cannot be null');
        }
        $this->container['total_due'] = $total_due;

        return $this;
    }

    /**
     * Gets displayable_total
     *
     * @return float|null
     */
    public function getDisplayableTotal()
    {
        return $this->container['displayable_total'];
    }

    /**
     * Sets displayable_total
     *
     * @param float|null $displayable_total Displayable total amount
     *
     * @return self
     */
    public function setDisplayableTotal($displayable_total)
    {
        if (is_null($displayable_total)) {
            throw new \InvalidArgumentException('non-nullable displayable_total cannot be null');
        }
        $this->container['displayable_total'] = $displayable_total;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return float|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param float|null $balance Balance remaining
     *
     * @return self
     */
    public function setBalance($balance)
    {
        if (is_null($balance)) {
            throw new \InvalidArgumentException('non-nullable balance cannot be null');
        }
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Associated customer ID
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets discount_id
     *
     * @return int|null
     */
    public function getDiscountId()
    {
        return $this->container['discount_id'];
    }

    /**
     * Sets discount_id
     *
     * @param int|null $discount_id Associated discount ID
     *
     * @return self
     */
    public function setDiscountId($discount_id)
    {
        if (is_null($discount_id)) {
            throw new \InvalidArgumentException('non-nullable discount_id cannot be null');
        }
        $this->container['discount_id'] = $discount_id;

        return $this;
    }

    /**
     * Gets employee_id
     *
     * @return int|null
     */
    public function getEmployeeId()
    {
        return $this->container['employee_id'];
    }

    /**
     * Sets employee_id
     *
     * @param int|null $employee_id Associated employee ID
     *
     * @return self
     */
    public function setEmployeeId($employee_id)
    {
        if (is_null($employee_id)) {
            throw new \InvalidArgumentException('non-nullable employee_id cannot be null');
        }
        $this->container['employee_id'] = $employee_id;

        return $this;
    }

    /**
     * Gets quote_id
     *
     * @return int|null
     */
    public function getQuoteId()
    {
        return $this->container['quote_id'];
    }

    /**
     * Sets quote_id
     *
     * @param int|null $quote_id Associated quote ID
     *
     * @return self
     */
    public function setQuoteId($quote_id)
    {
        if (is_null($quote_id)) {
            throw new \InvalidArgumentException('non-nullable quote_id cannot be null');
        }
        $this->container['quote_id'] = $quote_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return int|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param int|null $register_id Register used for sale
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        if (is_null($register_id)) {
            throw new \InvalidArgumentException('non-nullable register_id cannot be null');
        }
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets ship_to_id
     *
     * @return int|null
     */
    public function getShipToId()
    {
        return $this->container['ship_to_id'];
    }

    /**
     * Sets ship_to_id
     *
     * @param int|null $ship_to_id Ship to ID
     *
     * @return self
     */
    public function setShipToId($ship_to_id)
    {
        if (is_null($ship_to_id)) {
            throw new \InvalidArgumentException('non-nullable ship_to_id cannot be null');
        }
        $this->container['ship_to_id'] = $ship_to_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id Shop where sale occurred
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets tax_category_id
     *
     * @return int|null
     */
    public function getTaxCategoryId()
    {
        return $this->container['tax_category_id'];
    }

    /**
     * Sets tax_category_id
     *
     * @param int|null $tax_category_id Tax category applied
     *
     * @return self
     */
    public function setTaxCategoryId($tax_category_id)
    {
        if (is_null($tax_category_id)) {
            throw new \InvalidArgumentException('non-nullable tax_category_id cannot be null');
        }
        $this->container['tax_category_id'] = $tax_category_id;

        return $this;
    }

    /**
     * Gets tippable_amount
     *
     * @return float|null
     */
    public function getTippableAmount()
    {
        return $this->container['tippable_amount'];
    }

    /**
     * Sets tippable_amount
     *
     * @param float|null $tippable_amount Tippable amount
     *
     * @return self
     */
    public function setTippableAmount($tippable_amount)
    {
        if (is_null($tippable_amount)) {
            throw new \InvalidArgumentException('non-nullable tippable_amount cannot be null');
        }
        $this->container['tippable_amount'] = $tippable_amount;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total Total tax amount
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        if (is_null($tax_total)) {
            throw new \InvalidArgumentException('non-nullable tax_total cannot be null');
        }
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets sale_lines
     *
     * @return \LightspeedV3\Model\SaleLinesWrapper|null
     */
    public function getSaleLines()
    {
        return $this->container['sale_lines'];
    }

    /**
     * Sets sale_lines
     *
     * @param \LightspeedV3\Model\SaleLinesWrapper|null $sale_lines sale_lines
     *
     * @return self
     */
    public function setSaleLines($sale_lines)
    {
        if (is_null($sale_lines)) {
            throw new \InvalidArgumentException('non-nullable sale_lines cannot be null');
        }
        $this->container['sale_lines'] = $sale_lines;

        return $this;
    }

    /**
     * Gets sale_payments
     *
     * @return \LightspeedV3\Model\SalePaymentsWrapper|null
     */
    public function getSalePayments()
    {
        return $this->container['sale_payments'];
    }

    /**
     * Sets sale_payments
     *
     * @param \LightspeedV3\Model\SalePaymentsWrapper|null $sale_payments sale_payments
     *
     * @return self
     */
    public function setSalePayments($sale_payments)
    {
        if (is_null($sale_payments)) {
            throw new \InvalidArgumentException('non-nullable sale_payments cannot be null');
        }
        $this->container['sale_payments'] = $sale_payments;

        return $this;
    }

    /**
     * Gets sale_notes
     *
     * @return \LightspeedV3\Model\SaleNotesWrapper|null
     */
    public function getSaleNotes()
    {
        return $this->container['sale_notes'];
    }

    /**
     * Sets sale_notes
     *
     * @param \LightspeedV3\Model\SaleNotesWrapper|null $sale_notes sale_notes
     *
     * @return self
     */
    public function setSaleNotes($sale_notes)
    {
        if (is_null($sale_notes)) {
            throw new \InvalidArgumentException('non-nullable sale_notes cannot be null');
        }
        $this->container['sale_notes'] = $sale_notes;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \LightspeedV3\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \LightspeedV3\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets shop
     *
     * @return \LightspeedV3\Model\Shop|null
     */
    public function getShop()
    {
        return $this->container['shop'];
    }

    /**
     * Sets shop
     *
     * @param \LightspeedV3\Model\Shop|null $shop shop
     *
     * @return self
     */
    public function setShop($shop)
    {
        if (is_null($shop)) {
            throw new \InvalidArgumentException('non-nullable shop cannot be null');
        }
        $this->container['shop'] = $shop;

        return $this;
    }

    /**
     * Gets tax_category
     *
     * @return \LightspeedV3\Model\TaxCategory|null
     */
    public function getTaxCategory()
    {
        return $this->container['tax_category'];
    }

    /**
     * Sets tax_category
     *
     * @param \LightspeedV3\Model\TaxCategory|null $tax_category tax_category
     *
     * @return self
     */
    public function setTaxCategory($tax_category)
    {
        if (is_null($tax_category)) {
            throw new \InvalidArgumentException('non-nullable tax_category cannot be null');
        }
        $this->container['tax_category'] = $tax_category;

        return $this;
    }

    /**
     * Gets tax_class_totals
     *
     * @return \LightspeedV3\Model\TaxClassTotals|null
     */
    public function getTaxClassTotals()
    {
        return $this->container['tax_class_totals'];
    }

    /**
     * Sets tax_class_totals
     *
     * @param \LightspeedV3\Model\TaxClassTotals|null $tax_class_totals tax_class_totals
     *
     * @return self
     */
    public function setTaxClassTotals($tax_class_totals)
    {
        if (is_null($tax_class_totals)) {
            throw new \InvalidArgumentException('non-nullable tax_class_totals cannot be null');
        }
        $this->container['tax_class_totals'] = $tax_class_totals;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return \LightspeedV3\Model\Discount|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param \LightspeedV3\Model\Discount|null $discount discount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets quote
     *
     * @return \LightspeedV3\Model\Quote|null
     */
    public function getQuote()
    {
        return $this->container['quote'];
    }

    /**
     * Sets quote
     *
     * @param \LightspeedV3\Model\Quote|null $quote quote
     *
     * @return self
     */
    public function setQuote($quote)
    {
        if (is_null($quote)) {
            throw new \InvalidArgumentException('non-nullable quote cannot be null');
        }
        $this->container['quote'] = $quote;

        return $this;
    }

    /**
     * Gets ship_to
     *
     * @return \LightspeedV3\Model\ShipTo|null
     */
    public function getShipTo()
    {
        return $this->container['ship_to'];
    }

    /**
     * Sets ship_to
     *
     * @param \LightspeedV3\Model\ShipTo|null $ship_to ship_to
     *
     * @return self
     */
    public function setShipTo($ship_to)
    {
        if (is_null($ship_to)) {
            throw new \InvalidArgumentException('non-nullable ship_to cannot be null');
        }
        $this->container['ship_to'] = $ship_to;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


