<?php
/**
 * Register
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * Register Class Doc Comment
 *
 * @category Class
 * @description Register information
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Register implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Register';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'register_id' => 'int',
        'name' => 'string',
        'open' => 'bool',
        'open_time' => '\DateTime',
        'tip_enabled' => 'bool',
        'archived' => 'bool',
        'open_employee_id' => 'int',
        'shop_id' => 'int',
        'cc_terminal_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'register_id' => null,
        'name' => null,
        'open' => null,
        'open_time' => 'date-time',
        'tip_enabled' => null,
        'archived' => null,
        'open_employee_id' => null,
        'shop_id' => null,
        'cc_terminal_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'register_id' => false,
        'name' => false,
        'open' => false,
        'open_time' => false,
        'tip_enabled' => false,
        'archived' => false,
        'open_employee_id' => false,
        'shop_id' => false,
        'cc_terminal_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'register_id' => 'registerID',
        'name' => 'name',
        'open' => 'open',
        'open_time' => 'openTime',
        'tip_enabled' => 'tipEnabled',
        'archived' => 'archived',
        'open_employee_id' => 'openEmployeeID',
        'shop_id' => 'shopID',
        'cc_terminal_id' => 'ccTerminalID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'register_id' => 'setRegisterId',
        'name' => 'setName',
        'open' => 'setOpen',
        'open_time' => 'setOpenTime',
        'tip_enabled' => 'setTipEnabled',
        'archived' => 'setArchived',
        'open_employee_id' => 'setOpenEmployeeId',
        'shop_id' => 'setShopId',
        'cc_terminal_id' => 'setCcTerminalId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'register_id' => 'getRegisterId',
        'name' => 'getName',
        'open' => 'getOpen',
        'open_time' => 'getOpenTime',
        'tip_enabled' => 'getTipEnabled',
        'archived' => 'getArchived',
        'open_employee_id' => 'getOpenEmployeeId',
        'shop_id' => 'getShopId',
        'cc_terminal_id' => 'getCcTerminalId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('register_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('open', $data ?? [], null);
        $this->setIfExists('open_time', $data ?? [], null);
        $this->setIfExists('tip_enabled', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], false);
        $this->setIfExists('open_employee_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('cc_terminal_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['register_id'] === null) {
            $invalidProperties[] = "'register_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets register_id
     *
     * @return int
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param int $register_id Unique register identifier
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        if (is_null($register_id)) {
            throw new \InvalidArgumentException('non-nullable register_id cannot be null');
        }
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Register description/name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets open
     *
     * @return bool|null
     */
    public function getOpen()
    {
        return $this->container['open'];
    }

    /**
     * Sets open
     *
     * @param bool|null $open Current register open status
     *
     * @return self
     */
    public function setOpen($open)
    {
        if (is_null($open)) {
            throw new \InvalidArgumentException('non-nullable open cannot be null');
        }
        $this->container['open'] = $open;

        return $this;
    }

    /**
     * Gets open_time
     *
     * @return \DateTime|null
     */
    public function getOpenTime()
    {
        return $this->container['open_time'];
    }

    /**
     * Sets open_time
     *
     * @param \DateTime|null $open_time Date/time register was opened
     *
     * @return self
     */
    public function setOpenTime($open_time)
    {
        if (is_null($open_time)) {
            throw new \InvalidArgumentException('non-nullable open_time cannot be null');
        }
        $this->container['open_time'] = $open_time;

        return $this;
    }

    /**
     * Gets tip_enabled
     *
     * @return bool|null
     */
    public function getTipEnabled()
    {
        return $this->container['tip_enabled'];
    }

    /**
     * Sets tip_enabled
     *
     * @param bool|null $tip_enabled Indicates if tipping is allowed
     *
     * @return self
     */
    public function setTipEnabled($tip_enabled)
    {
        if (is_null($tip_enabled)) {
            throw new \InvalidArgumentException('non-nullable tip_enabled cannot be null');
        }
        $this->container['tip_enabled'] = $tip_enabled;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Whether register is archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets open_employee_id
     *
     * @return int|null
     */
    public function getOpenEmployeeId()
    {
        return $this->container['open_employee_id'];
    }

    /**
     * Sets open_employee_id
     *
     * @param int|null $open_employee_id Foreign key for employee who opened register
     *
     * @return self
     */
    public function setOpenEmployeeId($open_employee_id)
    {
        if (is_null($open_employee_id)) {
            throw new \InvalidArgumentException('non-nullable open_employee_id cannot be null');
        }
        $this->container['open_employee_id'] = $open_employee_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id Foreign key for shop location
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets cc_terminal_id
     *
     * @return int|null
     */
    public function getCcTerminalId()
    {
        return $this->container['cc_terminal_id'];
    }

    /**
     * Sets cc_terminal_id
     *
     * @param int|null $cc_terminal_id Credit card terminal ID
     *
     * @return self
     */
    public function setCcTerminalId($cc_terminal_id)
    {
        if (is_null($cc_terminal_id)) {
            throw new \InvalidArgumentException('non-nullable cc_terminal_id cannot be null');
        }
        $this->container['cc_terminal_id'] = $cc_terminal_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


