<?php
/**
 * OrderLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * OrderLine Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_line_id' => 'string',
        'quantity' => 'string',
        'price' => 'string',
        'original_price' => 'string',
        'vendor_cost' => 'string',
        'checked_in' => 'string',
        'num_received' => 'string',
        'time_stamp' => 'string',
        'total' => 'string',
        'create_time' => 'string',
        'shipping_cost' => 'string',
        'shipping_vendor_cost' => 'string',
        'discount_money_value' => 'string',
        'discount_money_vendor_value' => 'string',
        'discount_percent_value' => 'string',
        'order_id' => 'string',
        'item_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_line_id' => null,
        'quantity' => null,
        'price' => null,
        'original_price' => null,
        'vendor_cost' => null,
        'checked_in' => null,
        'num_received' => null,
        'time_stamp' => null,
        'total' => null,
        'create_time' => null,
        'shipping_cost' => null,
        'shipping_vendor_cost' => null,
        'discount_money_value' => null,
        'discount_money_vendor_value' => null,
        'discount_percent_value' => null,
        'order_id' => null,
        'item_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_line_id' => false,
        'quantity' => false,
        'price' => false,
        'original_price' => false,
        'vendor_cost' => false,
        'checked_in' => false,
        'num_received' => false,
        'time_stamp' => false,
        'total' => false,
        'create_time' => false,
        'shipping_cost' => false,
        'shipping_vendor_cost' => false,
        'discount_money_value' => false,
        'discount_money_vendor_value' => false,
        'discount_percent_value' => false,
        'order_id' => false,
        'item_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_line_id' => 'orderLineID',
        'quantity' => 'quantity',
        'price' => 'price',
        'original_price' => 'originalPrice',
        'vendor_cost' => 'vendorCost',
        'checked_in' => 'checkedIn',
        'num_received' => 'numReceived',
        'time_stamp' => 'timeStamp',
        'total' => 'total',
        'create_time' => 'createTime',
        'shipping_cost' => 'shippingCost',
        'shipping_vendor_cost' => 'shippingVendorCost',
        'discount_money_value' => 'discountMoneyValue',
        'discount_money_vendor_value' => 'discountMoneyVendorValue',
        'discount_percent_value' => 'discountPercentValue',
        'order_id' => 'orderID',
        'item_id' => 'itemID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_line_id' => 'setOrderLineId',
        'quantity' => 'setQuantity',
        'price' => 'setPrice',
        'original_price' => 'setOriginalPrice',
        'vendor_cost' => 'setVendorCost',
        'checked_in' => 'setCheckedIn',
        'num_received' => 'setNumReceived',
        'time_stamp' => 'setTimeStamp',
        'total' => 'setTotal',
        'create_time' => 'setCreateTime',
        'shipping_cost' => 'setShippingCost',
        'shipping_vendor_cost' => 'setShippingVendorCost',
        'discount_money_value' => 'setDiscountMoneyValue',
        'discount_money_vendor_value' => 'setDiscountMoneyVendorValue',
        'discount_percent_value' => 'setDiscountPercentValue',
        'order_id' => 'setOrderId',
        'item_id' => 'setItemId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_line_id' => 'getOrderLineId',
        'quantity' => 'getQuantity',
        'price' => 'getPrice',
        'original_price' => 'getOriginalPrice',
        'vendor_cost' => 'getVendorCost',
        'checked_in' => 'getCheckedIn',
        'num_received' => 'getNumReceived',
        'time_stamp' => 'getTimeStamp',
        'total' => 'getTotal',
        'create_time' => 'getCreateTime',
        'shipping_cost' => 'getShippingCost',
        'shipping_vendor_cost' => 'getShippingVendorCost',
        'discount_money_value' => 'getDiscountMoneyValue',
        'discount_money_vendor_value' => 'getDiscountMoneyVendorValue',
        'discount_percent_value' => 'getDiscountPercentValue',
        'order_id' => 'getOrderId',
        'item_id' => 'getItemId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_line_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('original_price', $data ?? [], null);
        $this->setIfExists('vendor_cost', $data ?? [], null);
        $this->setIfExists('checked_in', $data ?? [], null);
        $this->setIfExists('num_received', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('shipping_cost', $data ?? [], null);
        $this->setIfExists('shipping_vendor_cost', $data ?? [], null);
        $this->setIfExists('discount_money_value', $data ?? [], null);
        $this->setIfExists('discount_money_vendor_value', $data ?? [], null);
        $this->setIfExists('discount_percent_value', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_line_id
     *
     * @return string|null
     */
    public function getOrderLineId()
    {
        return $this->container['order_line_id'];
    }

    /**
     * Sets order_line_id
     *
     * @param string|null $order_line_id order_line_id
     *
     * @return self
     */
    public function setOrderLineId($order_line_id)
    {
        if (is_null($order_line_id)) {
            throw new \InvalidArgumentException('non-nullable order_line_id cannot be null');
        }
        $this->container['order_line_id'] = $order_line_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param string|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets price
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param string|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets original_price
     *
     * @return string|null
     */
    public function getOriginalPrice()
    {
        return $this->container['original_price'];
    }

    /**
     * Sets original_price
     *
     * @param string|null $original_price original_price
     *
     * @return self
     */
    public function setOriginalPrice($original_price)
    {
        if (is_null($original_price)) {
            throw new \InvalidArgumentException('non-nullable original_price cannot be null');
        }
        $this->container['original_price'] = $original_price;

        return $this;
    }

    /**
     * Gets vendor_cost
     *
     * @return string|null
     */
    public function getVendorCost()
    {
        return $this->container['vendor_cost'];
    }

    /**
     * Sets vendor_cost
     *
     * @param string|null $vendor_cost vendor_cost
     *
     * @return self
     */
    public function setVendorCost($vendor_cost)
    {
        if (is_null($vendor_cost)) {
            throw new \InvalidArgumentException('non-nullable vendor_cost cannot be null');
        }
        $this->container['vendor_cost'] = $vendor_cost;

        return $this;
    }

    /**
     * Gets checked_in
     *
     * @return string|null
     */
    public function getCheckedIn()
    {
        return $this->container['checked_in'];
    }

    /**
     * Sets checked_in
     *
     * @param string|null $checked_in checked_in
     *
     * @return self
     */
    public function setCheckedIn($checked_in)
    {
        if (is_null($checked_in)) {
            throw new \InvalidArgumentException('non-nullable checked_in cannot be null');
        }
        $this->container['checked_in'] = $checked_in;

        return $this;
    }

    /**
     * Gets num_received
     *
     * @return string|null
     */
    public function getNumReceived()
    {
        return $this->container['num_received'];
    }

    /**
     * Sets num_received
     *
     * @param string|null $num_received num_received
     *
     * @return self
     */
    public function setNumReceived($num_received)
    {
        if (is_null($num_received)) {
            throw new \InvalidArgumentException('non-nullable num_received cannot be null');
        }
        $this->container['num_received'] = $num_received;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param string|null $time_stamp time_stamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets total
     *
     * @return string|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param string|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return string|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param string|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets shipping_cost
     *
     * @return string|null
     */
    public function getShippingCost()
    {
        return $this->container['shipping_cost'];
    }

    /**
     * Sets shipping_cost
     *
     * @param string|null $shipping_cost shipping_cost
     *
     * @return self
     */
    public function setShippingCost($shipping_cost)
    {
        if (is_null($shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost cannot be null');
        }
        $this->container['shipping_cost'] = $shipping_cost;

        return $this;
    }

    /**
     * Gets shipping_vendor_cost
     *
     * @return string|null
     */
    public function getShippingVendorCost()
    {
        return $this->container['shipping_vendor_cost'];
    }

    /**
     * Sets shipping_vendor_cost
     *
     * @param string|null $shipping_vendor_cost shipping_vendor_cost
     *
     * @return self
     */
    public function setShippingVendorCost($shipping_vendor_cost)
    {
        if (is_null($shipping_vendor_cost)) {
            throw new \InvalidArgumentException('non-nullable shipping_vendor_cost cannot be null');
        }
        $this->container['shipping_vendor_cost'] = $shipping_vendor_cost;

        return $this;
    }

    /**
     * Gets discount_money_value
     *
     * @return string|null
     */
    public function getDiscountMoneyValue()
    {
        return $this->container['discount_money_value'];
    }

    /**
     * Sets discount_money_value
     *
     * @param string|null $discount_money_value discount_money_value
     *
     * @return self
     */
    public function setDiscountMoneyValue($discount_money_value)
    {
        if (is_null($discount_money_value)) {
            throw new \InvalidArgumentException('non-nullable discount_money_value cannot be null');
        }
        $this->container['discount_money_value'] = $discount_money_value;

        return $this;
    }

    /**
     * Gets discount_money_vendor_value
     *
     * @return string|null
     */
    public function getDiscountMoneyVendorValue()
    {
        return $this->container['discount_money_vendor_value'];
    }

    /**
     * Sets discount_money_vendor_value
     *
     * @param string|null $discount_money_vendor_value discount_money_vendor_value
     *
     * @return self
     */
    public function setDiscountMoneyVendorValue($discount_money_vendor_value)
    {
        if (is_null($discount_money_vendor_value)) {
            throw new \InvalidArgumentException('non-nullable discount_money_vendor_value cannot be null');
        }
        $this->container['discount_money_vendor_value'] = $discount_money_vendor_value;

        return $this;
    }

    /**
     * Gets discount_percent_value
     *
     * @return string|null
     */
    public function getDiscountPercentValue()
    {
        return $this->container['discount_percent_value'];
    }

    /**
     * Sets discount_percent_value
     *
     * @param string|null $discount_percent_value discount_percent_value
     *
     * @return self
     */
    public function setDiscountPercentValue($discount_percent_value)
    {
        if (is_null($discount_percent_value)) {
            throw new \InvalidArgumentException('non-nullable discount_percent_value cannot be null');
        }
        $this->container['discount_percent_value'] = $discount_percent_value;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id order_id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return string|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param string|null $item_id item_id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


