<?php
/**
 * OrderCreateRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * OrderCreateRequest Class Doc Comment
 *
 * @category Class
 * @description Order creation request
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderCreateRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderCreateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ordered_date' => '\DateTime',
        'arrival_date' => '\DateTime',
        'ref_num' => 'string',
        'ship_instructions' => 'string',
        'stock_instructions' => 'string',
        'ship_cost' => 'float',
        'other_cost' => 'float',
        'discount' => 'float',
        'vendor_id' => 'int',
        'shop_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ordered_date' => 'date-time',
        'arrival_date' => 'date-time',
        'ref_num' => null,
        'ship_instructions' => null,
        'stock_instructions' => null,
        'ship_cost' => 'float',
        'other_cost' => 'float',
        'discount' => 'float',
        'vendor_id' => null,
        'shop_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'ordered_date' => false,
        'arrival_date' => false,
        'ref_num' => false,
        'ship_instructions' => false,
        'stock_instructions' => false,
        'ship_cost' => false,
        'other_cost' => false,
        'discount' => false,
        'vendor_id' => false,
        'shop_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ordered_date' => 'orderedDate',
        'arrival_date' => 'arrivalDate',
        'ref_num' => 'refNum',
        'ship_instructions' => 'shipInstructions',
        'stock_instructions' => 'stockInstructions',
        'ship_cost' => 'shipCost',
        'other_cost' => 'otherCost',
        'discount' => 'discount',
        'vendor_id' => 'vendorID',
        'shop_id' => 'shopID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ordered_date' => 'setOrderedDate',
        'arrival_date' => 'setArrivalDate',
        'ref_num' => 'setRefNum',
        'ship_instructions' => 'setShipInstructions',
        'stock_instructions' => 'setStockInstructions',
        'ship_cost' => 'setShipCost',
        'other_cost' => 'setOtherCost',
        'discount' => 'setDiscount',
        'vendor_id' => 'setVendorId',
        'shop_id' => 'setShopId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ordered_date' => 'getOrderedDate',
        'arrival_date' => 'getArrivalDate',
        'ref_num' => 'getRefNum',
        'ship_instructions' => 'getShipInstructions',
        'stock_instructions' => 'getStockInstructions',
        'ship_cost' => 'getShipCost',
        'other_cost' => 'getOtherCost',
        'discount' => 'getDiscount',
        'vendor_id' => 'getVendorId',
        'shop_id' => 'getShopId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('ordered_date', $data ?? [], null);
        $this->setIfExists('arrival_date', $data ?? [], null);
        $this->setIfExists('ref_num', $data ?? [], null);
        $this->setIfExists('ship_instructions', $data ?? [], null);
        $this->setIfExists('stock_instructions', $data ?? [], null);
        $this->setIfExists('ship_cost', $data ?? [], null);
        $this->setIfExists('other_cost', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('vendor_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['vendor_id'] === null) {
            $invalidProperties[] = "'vendor_id' can't be null";
        }
        if ($this->container['shop_id'] === null) {
            $invalidProperties[] = "'shop_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ordered_date
     *
     * @return \DateTime|null
     */
    public function getOrderedDate()
    {
        return $this->container['ordered_date'];
    }

    /**
     * Sets ordered_date
     *
     * @param \DateTime|null $ordered_date Date order was placed with vendor
     *
     * @return self
     */
    public function setOrderedDate($ordered_date)
    {
        if (is_null($ordered_date)) {
            throw new \InvalidArgumentException('non-nullable ordered_date cannot be null');
        }
        $this->container['ordered_date'] = $ordered_date;

        return $this;
    }

    /**
     * Gets arrival_date
     *
     * @return \DateTime|null
     */
    public function getArrivalDate()
    {
        return $this->container['arrival_date'];
    }

    /**
     * Sets arrival_date
     *
     * @param \DateTime|null $arrival_date Expected arrival date
     *
     * @return self
     */
    public function setArrivalDate($arrival_date)
    {
        if (is_null($arrival_date)) {
            throw new \InvalidArgumentException('non-nullable arrival_date cannot be null');
        }
        $this->container['arrival_date'] = $arrival_date;

        return $this;
    }

    /**
     * Gets ref_num
     *
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->container['ref_num'];
    }

    /**
     * Sets ref_num
     *
     * @param string|null $ref_num External reference number
     *
     * @return self
     */
    public function setRefNum($ref_num)
    {
        if (is_null($ref_num)) {
            throw new \InvalidArgumentException('non-nullable ref_num cannot be null');
        }
        $this->container['ref_num'] = $ref_num;

        return $this;
    }

    /**
     * Gets ship_instructions
     *
     * @return string|null
     */
    public function getShipInstructions()
    {
        return $this->container['ship_instructions'];
    }

    /**
     * Sets ship_instructions
     *
     * @param string|null $ship_instructions Shipping instructions
     *
     * @return self
     */
    public function setShipInstructions($ship_instructions)
    {
        if (is_null($ship_instructions)) {
            throw new \InvalidArgumentException('non-nullable ship_instructions cannot be null');
        }
        $this->container['ship_instructions'] = $ship_instructions;

        return $this;
    }

    /**
     * Gets stock_instructions
     *
     * @return string|null
     */
    public function getStockInstructions()
    {
        return $this->container['stock_instructions'];
    }

    /**
     * Sets stock_instructions
     *
     * @param string|null $stock_instructions Inventory stocking instructions
     *
     * @return self
     */
    public function setStockInstructions($stock_instructions)
    {
        if (is_null($stock_instructions)) {
            throw new \InvalidArgumentException('non-nullable stock_instructions cannot be null');
        }
        $this->container['stock_instructions'] = $stock_instructions;

        return $this;
    }

    /**
     * Gets ship_cost
     *
     * @return float|null
     */
    public function getShipCost()
    {
        return $this->container['ship_cost'];
    }

    /**
     * Sets ship_cost
     *
     * @param float|null $ship_cost Shipping costs
     *
     * @return self
     */
    public function setShipCost($ship_cost)
    {
        if (is_null($ship_cost)) {
            throw new \InvalidArgumentException('non-nullable ship_cost cannot be null');
        }
        $this->container['ship_cost'] = $ship_cost;

        return $this;
    }

    /**
     * Gets other_cost
     *
     * @return float|null
     */
    public function getOtherCost()
    {
        return $this->container['other_cost'];
    }

    /**
     * Sets other_cost
     *
     * @param float|null $other_cost Additional vendor costs
     *
     * @return self
     */
    public function setOtherCost($other_cost)
    {
        if (is_null($other_cost)) {
            throw new \InvalidArgumentException('non-nullable other_cost cannot be null');
        }
        $this->container['other_cost'] = $other_cost;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param float|null $discount Percentage discount on order
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets vendor_id
     *
     * @return int
     */
    public function getVendorId()
    {
        return $this->container['vendor_id'];
    }

    /**
     * Sets vendor_id
     *
     * @param int $vendor_id Vendor identifier
     *
     * @return self
     */
    public function setVendorId($vendor_id)
    {
        if (is_null($vendor_id)) {
            throw new \InvalidArgumentException('non-nullable vendor_id cannot be null');
        }
        $this->container['vendor_id'] = $vendor_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int $shop_id Shop identifier
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }
        $this->container['shop_id'] = $shop_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


