<?php
/**
 * ItemUpdateRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Lightspeed Retail (R-Series) API
 *
 * API for Lightspeed Retail POS system. This specification covers the R-Series API endpoints.  NOTE: This is an abridged version of the R-Series API Documentation. For more detailed documentation, visit [API Developer Documentation](https://developers.lightspeedhq.com/retail/)
 *
 * The version of the OpenAPI document: 3.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.16.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace LightspeedV3\Model;

use \ArrayAccess;
use \LightspeedV3\ObjectSerializer;

/**
 * ItemUpdateRequest Class Doc Comment
 *
 * @category Class
 * @package  LightspeedV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemUpdateRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemUpdateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_matrix_id' => 'int',
        'description' => 'string',
        'tax' => 'string',
        'default_cost' => 'float',
        'item_type' => 'string',
        'serialized' => 'bool',
        'model_year' => 'int',
        'archived' => 'bool',
        'time_stamp' => 'string',
        'item_attribute_set_id' => 'int',
        'manufacturer_id' => 'int',
        'category_id' => 'int',
        'default_vendor_id' => 'int',
        'tax_class_id' => 'int',
        'season_id' => 'int',
        'department_id' => 'int',
        'item_attribute_set' => '\LightspeedV3\Model\ItemAttributeSet',
        'category' => '\LightspeedV3\Model\Category',
        'tax_class' => '\LightspeedV3\Model\TaxClass',
        'items' => '\LightspeedV3\Model\ItemMatrixItems',
        'prices' => '\LightspeedV3\Model\ItemPrices',
        'attribute2_values' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_matrix_id' => null,
        'description' => null,
        'tax' => null,
        'default_cost' => null,
        'item_type' => null,
        'serialized' => null,
        'model_year' => null,
        'archived' => null,
        'time_stamp' => null,
        'item_attribute_set_id' => null,
        'manufacturer_id' => null,
        'category_id' => null,
        'default_vendor_id' => null,
        'tax_class_id' => null,
        'season_id' => null,
        'department_id' => null,
        'item_attribute_set' => null,
        'category' => null,
        'tax_class' => null,
        'items' => null,
        'prices' => null,
        'attribute2_values' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_matrix_id' => false,
        'description' => false,
        'tax' => false,
        'default_cost' => false,
        'item_type' => false,
        'serialized' => false,
        'model_year' => false,
        'archived' => false,
        'time_stamp' => false,
        'item_attribute_set_id' => false,
        'manufacturer_id' => false,
        'category_id' => false,
        'default_vendor_id' => false,
        'tax_class_id' => false,
        'season_id' => false,
        'department_id' => false,
        'item_attribute_set' => false,
        'category' => false,
        'tax_class' => false,
        'items' => false,
        'prices' => false,
        'attribute2_values' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_matrix_id' => 'itemMatrixID',
        'description' => 'description',
        'tax' => 'tax',
        'default_cost' => 'defaultCost',
        'item_type' => 'itemType',
        'serialized' => 'serialized',
        'model_year' => 'modelYear',
        'archived' => 'archived',
        'time_stamp' => 'timeStamp',
        'item_attribute_set_id' => 'itemAttributeSetID',
        'manufacturer_id' => 'manufacturerID',
        'category_id' => 'categoryID',
        'default_vendor_id' => 'defaultVendorID',
        'tax_class_id' => 'taxClassID',
        'season_id' => 'seasonID',
        'department_id' => 'departmentID',
        'item_attribute_set' => 'ItemAttributeSet',
        'category' => 'Category',
        'tax_class' => 'TaxClass',
        'items' => 'Items',
        'prices' => 'Prices',
        'attribute2_values' => 'attribute2Values'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_matrix_id' => 'setItemMatrixId',
        'description' => 'setDescription',
        'tax' => 'setTax',
        'default_cost' => 'setDefaultCost',
        'item_type' => 'setItemType',
        'serialized' => 'setSerialized',
        'model_year' => 'setModelYear',
        'archived' => 'setArchived',
        'time_stamp' => 'setTimeStamp',
        'item_attribute_set_id' => 'setItemAttributeSetId',
        'manufacturer_id' => 'setManufacturerId',
        'category_id' => 'setCategoryId',
        'default_vendor_id' => 'setDefaultVendorId',
        'tax_class_id' => 'setTaxClassId',
        'season_id' => 'setSeasonId',
        'department_id' => 'setDepartmentId',
        'item_attribute_set' => 'setItemAttributeSet',
        'category' => 'setCategory',
        'tax_class' => 'setTaxClass',
        'items' => 'setItems',
        'prices' => 'setPrices',
        'attribute2_values' => 'setAttribute2Values'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_matrix_id' => 'getItemMatrixId',
        'description' => 'getDescription',
        'tax' => 'getTax',
        'default_cost' => 'getDefaultCost',
        'item_type' => 'getItemType',
        'serialized' => 'getSerialized',
        'model_year' => 'getModelYear',
        'archived' => 'getArchived',
        'time_stamp' => 'getTimeStamp',
        'item_attribute_set_id' => 'getItemAttributeSetId',
        'manufacturer_id' => 'getManufacturerId',
        'category_id' => 'getCategoryId',
        'default_vendor_id' => 'getDefaultVendorId',
        'tax_class_id' => 'getTaxClassId',
        'season_id' => 'getSeasonId',
        'department_id' => 'getDepartmentId',
        'item_attribute_set' => 'getItemAttributeSet',
        'category' => 'getCategory',
        'tax_class' => 'getTaxClass',
        'items' => 'getItems',
        'prices' => 'getPrices',
        'attribute2_values' => 'getAttribute2Values'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_matrix_id', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('default_cost', $data ?? [], null);
        $this->setIfExists('item_type', $data ?? [], null);
        $this->setIfExists('serialized', $data ?? [], null);
        $this->setIfExists('model_year', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], null);
        $this->setIfExists('time_stamp', $data ?? [], null);
        $this->setIfExists('item_attribute_set_id', $data ?? [], null);
        $this->setIfExists('manufacturer_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('default_vendor_id', $data ?? [], null);
        $this->setIfExists('tax_class_id', $data ?? [], null);
        $this->setIfExists('season_id', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('item_attribute_set', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('prices', $data ?? [], null);
        $this->setIfExists('attribute2_values', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_matrix_id
     *
     * @return int|null
     */
    public function getItemMatrixId()
    {
        return $this->container['item_matrix_id'];
    }

    /**
     * Sets item_matrix_id
     *
     * @param int|null $item_matrix_id item_matrix_id
     *
     * @return self
     */
    public function setItemMatrixId($item_matrix_id)
    {
        if (is_null($item_matrix_id)) {
            throw new \InvalidArgumentException('non-nullable item_matrix_id cannot be null');
        }
        $this->container['item_matrix_id'] = $item_matrix_id;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return string|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param string|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets default_cost
     *
     * @return float|null
     */
    public function getDefaultCost()
    {
        return $this->container['default_cost'];
    }

    /**
     * Sets default_cost
     *
     * @param float|null $default_cost default_cost
     *
     * @return self
     */
    public function setDefaultCost($default_cost)
    {
        if (is_null($default_cost)) {
            throw new \InvalidArgumentException('non-nullable default_cost cannot be null');
        }
        $this->container['default_cost'] = $default_cost;

        return $this;
    }

    /**
     * Gets item_type
     *
     * @return string|null
     */
    public function getItemType()
    {
        return $this->container['item_type'];
    }

    /**
     * Sets item_type
     *
     * @param string|null $item_type item_type
     *
     * @return self
     */
    public function setItemType($item_type)
    {
        if (is_null($item_type)) {
            throw new \InvalidArgumentException('non-nullable item_type cannot be null');
        }
        $this->container['item_type'] = $item_type;

        return $this;
    }

    /**
     * Gets serialized
     *
     * @return bool|null
     */
    public function getSerialized()
    {
        return $this->container['serialized'];
    }

    /**
     * Sets serialized
     *
     * @param bool|null $serialized serialized
     *
     * @return self
     */
    public function setSerialized($serialized)
    {
        if (is_null($serialized)) {
            throw new \InvalidArgumentException('non-nullable serialized cannot be null');
        }
        $this->container['serialized'] = $serialized;

        return $this;
    }

    /**
     * Gets model_year
     *
     * @return int|null
     */
    public function getModelYear()
    {
        return $this->container['model_year'];
    }

    /**
     * Sets model_year
     *
     * @param int|null $model_year model_year
     *
     * @return self
     */
    public function setModelYear($model_year)
    {
        if (is_null($model_year)) {
            throw new \InvalidArgumentException('non-nullable model_year cannot be null');
        }
        $this->container['model_year'] = $model_year;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool|null $archived Whether item is archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            throw new \InvalidArgumentException('non-nullable archived cannot be null');
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets time_stamp
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->container['time_stamp'];
    }

    /**
     * Sets time_stamp
     *
     * @param string|null $time_stamp time_stamp
     *
     * @return self
     */
    public function setTimeStamp($time_stamp)
    {
        if (is_null($time_stamp)) {
            throw new \InvalidArgumentException('non-nullable time_stamp cannot be null');
        }
        $this->container['time_stamp'] = $time_stamp;

        return $this;
    }

    /**
     * Gets item_attribute_set_id
     *
     * @return int|null
     */
    public function getItemAttributeSetId()
    {
        return $this->container['item_attribute_set_id'];
    }

    /**
     * Sets item_attribute_set_id
     *
     * @param int|null $item_attribute_set_id item_attribute_set_id
     *
     * @return self
     */
    public function setItemAttributeSetId($item_attribute_set_id)
    {
        if (is_null($item_attribute_set_id)) {
            throw new \InvalidArgumentException('non-nullable item_attribute_set_id cannot be null');
        }
        $this->container['item_attribute_set_id'] = $item_attribute_set_id;

        return $this;
    }

    /**
     * Gets manufacturer_id
     *
     * @return int|null
     */
    public function getManufacturerId()
    {
        return $this->container['manufacturer_id'];
    }

    /**
     * Sets manufacturer_id
     *
     * @param int|null $manufacturer_id manufacturer_id
     *
     * @return self
     */
    public function setManufacturerId($manufacturer_id)
    {
        if (is_null($manufacturer_id)) {
            throw new \InvalidArgumentException('non-nullable manufacturer_id cannot be null');
        }
        $this->container['manufacturer_id'] = $manufacturer_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id category_id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets default_vendor_id
     *
     * @return int|null
     */
    public function getDefaultVendorId()
    {
        return $this->container['default_vendor_id'];
    }

    /**
     * Sets default_vendor_id
     *
     * @param int|null $default_vendor_id default_vendor_id
     *
     * @return self
     */
    public function setDefaultVendorId($default_vendor_id)
    {
        if (is_null($default_vendor_id)) {
            throw new \InvalidArgumentException('non-nullable default_vendor_id cannot be null');
        }
        $this->container['default_vendor_id'] = $default_vendor_id;

        return $this;
    }

    /**
     * Gets tax_class_id
     *
     * @return int|null
     */
    public function getTaxClassId()
    {
        return $this->container['tax_class_id'];
    }

    /**
     * Sets tax_class_id
     *
     * @param int|null $tax_class_id tax_class_id
     *
     * @return self
     */
    public function setTaxClassId($tax_class_id)
    {
        if (is_null($tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable tax_class_id cannot be null');
        }
        $this->container['tax_class_id'] = $tax_class_id;

        return $this;
    }

    /**
     * Gets season_id
     *
     * @return int|null
     */
    public function getSeasonId()
    {
        return $this->container['season_id'];
    }

    /**
     * Sets season_id
     *
     * @param int|null $season_id season_id
     *
     * @return self
     */
    public function setSeasonId($season_id)
    {
        if (is_null($season_id)) {
            throw new \InvalidArgumentException('non-nullable season_id cannot be null');
        }
        $this->container['season_id'] = $season_id;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id department_id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets item_attribute_set
     *
     * @return \LightspeedV3\Model\ItemAttributeSet|null
     */
    public function getItemAttributeSet()
    {
        return $this->container['item_attribute_set'];
    }

    /**
     * Sets item_attribute_set
     *
     * @param \LightspeedV3\Model\ItemAttributeSet|null $item_attribute_set item_attribute_set
     *
     * @return self
     */
    public function setItemAttributeSet($item_attribute_set)
    {
        if (is_null($item_attribute_set)) {
            throw new \InvalidArgumentException('non-nullable item_attribute_set cannot be null');
        }
        $this->container['item_attribute_set'] = $item_attribute_set;

        return $this;
    }

    /**
     * Gets category
     *
     * @return \LightspeedV3\Model\Category|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param \LightspeedV3\Model\Category|null $category category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return \LightspeedV3\Model\TaxClass|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param \LightspeedV3\Model\TaxClass|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \LightspeedV3\Model\ItemMatrixItems|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \LightspeedV3\Model\ItemMatrixItems|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets prices
     *
     * @return \LightspeedV3\Model\ItemPrices|null
     */
    public function getPrices()
    {
        return $this->container['prices'];
    }

    /**
     * Sets prices
     *
     * @param \LightspeedV3\Model\ItemPrices|null $prices prices
     *
     * @return self
     */
    public function setPrices($prices)
    {
        if (is_null($prices)) {
            throw new \InvalidArgumentException('non-nullable prices cannot be null');
        }
        $this->container['prices'] = $prices;

        return $this;
    }

    /**
     * Gets attribute2_values
     *
     * @return string[]|null
     */
    public function getAttribute2Values()
    {
        return $this->container['attribute2_values'];
    }

    /**
     * Sets attribute2_values
     *
     * @param string[]|null $attribute2_values attribute2_values
     *
     * @return self
     */
    public function setAttribute2Values($attribute2_values)
    {
        if (is_null($attribute2_values)) {
            throw new \InvalidArgumentException('non-nullable attribute2_values cannot be null');
        }
        $this->container['attribute2_values'] = $attribute2_values;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


